/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.message;

import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import com.vhall.vhallrtc.message.ICECandidateMessage;
import com.vhall.vhallrtc.message.InitializingMessage;
import com.vhall.vhallrtc.message.ReadyMessage;
import com.vhall.vhallrtc.message.SessionDescriptionMessage;
import com.vhall.vhallrtc.message.SignalingMessageType;
import com.vhall.vhallrtc.message.StartedMessage;
import org.json.JSONObject;
import org.vhwebrtc.IceCandidate;
import org.vhwebrtc.SessionDescription;

public abstract class SignalingMessage {
    public String streamId = null;
    public String peerSocketId = null;
    public SignalingMessageType type;
    private static final String kVHSignalingMessageTypeKey = "type";
    private static final String kVHSignalingMessageAgentIdKey = "agentId";

    SignalingMessage(SignalingMessageType type, String streamId, String peerSocketId) {
        this.type = type;
        this.streamId = streamId;
        this.peerSocketId = peerSocketId;
    }

    public static SignalingMessage messageFromJsonObject(JSONObject messageDict) {
        SignalingMessage message = null;
        JSONObject values = null;
        String typeString = null;
        String streamId = null;
        String peerSocketId = null;
        values = messageDict.optJSONObject("mess");
        if (values == null) {
            values = messageDict.optJSONObject("msg");
        }
        if (values == null) {
            LogManager.e("VHSignalingMessage:messageFromDictionary unable to parse messageDict");
            return null;
        }
        typeString = values instanceof JSONObject ? values.optString(kVHSignalingMessageTypeKey) : values.toString();
        if (messageDict.has("streamId")) {
            streamId = Tool.objectToString(messageDict.opt("streamId"));
        }
        if (messageDict.has("peerId")) {
            streamId = Tool.objectToString(messageDict.opt("peerId"));
        }
        if (messageDict.has("peerSocket")) {
            peerSocketId = Tool.objectToString(messageDict.opt("peerSocket"));
        }
        if (typeString.equals("candidate")) {
            IceCandidate candidate = ICECandidateMessage.VHIceCandidate.candidateFromJSONObject(values);
            message = new ICECandidateMessage(candidate, streamId, peerSocketId);
        } else if (typeString.equals("offer") || typeString.equals("answer")) {
            SessionDescription description = SessionDescriptionMessage.VHSessionDescription.descriptionFromJSONObject(values);
            message = new SessionDescriptionMessage(description, streamId, peerSocketId);
        } else if (typeString.equals("initializing")) {
            message = new InitializingMessage(streamId, peerSocketId);
        } else if (typeString.equals("started")) {
            message = new StartedMessage(streamId, peerSocketId);
        } else if (typeString.equals("ready")) {
            message = new ReadyMessage(streamId, peerSocketId);
        } else {
            LogManager.d("unexpected type:" + typeString);
        }
        return message;
    }

    public abstract JSONObject jsonObject();
}

