/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.message;

import com.vhall.vhallrtc.message.SignalingMessage;
import com.vhall.vhallrtc.message.SignalingMessageType;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.IceCandidate;

public class ICECandidateMessage
extends SignalingMessage {
    private static final String kRTCICECandidateTypeKey = "type";
    private static final String kRTCICECandidateTypeValue = "candidate";
    private static final String kRTCICECandidateMidKey = "sdpMid";
    private static final String kRTCICECandidateMLineIndexKey = "sdpMLineIndex";
    private static final String kRTCICECandidateSdpKey = "candidate";
    private static final String kRTCICECandidatesTypeKey = "candidates";
    private IceCandidate mIceCandidate = null;

    public ICECandidateMessage(IceCandidate iceCandidate, String streamId, String peerSocketId) {
        super(SignalingMessageType.kVHSignalingMessageTypeCandidate, streamId, peerSocketId);
        this.mIceCandidate = iceCandidate;
    }

    public IceCandidate getIceCandidate() {
        return this.mIceCandidate;
    }

    @Override
    public JSONObject jsonObject() {
        JSONObject obj = null;
        try {
            obj = new JSONObject(this.mIceCandidate.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static class VHIceCandidate
    extends IceCandidate {
        public VHIceCandidate(String sdpMid, int sdpMLineIndex, String sdp) {
            super(sdpMid, sdpMLineIndex, sdp);
        }

        public static IceCandidate candidateFromJSONObject(JSONObject map) {
            String mid = map.optString(ICECandidateMessage.kRTCICECandidateMidKey);
            String sdp = map.optString("candidate");
            int lineIndex = map.optInt(ICECandidateMessage.kRTCICECandidateMLineIndexKey);
            return new IceCandidate(mid, lineIndex, sdp);
        }

        public String toString() {
            String sdp = this.sdp.equals("end") ? this.sdp : "a=" + this.sdp;
            JSONObject obj = new JSONObject();
            try {
                obj.put(ICECandidateMessage.kRTCICECandidateTypeKey, (Object)"candidate");
                JSONObject sdpObject = new JSONObject();
                sdpObject.put(ICECandidateMessage.kRTCICECandidateMLineIndexKey, this.sdpMLineIndex);
                sdpObject.put(ICECandidateMessage.kRTCICECandidateMidKey, (Object)this.sdpMid);
                sdpObject.put("candidate", (Object)sdp);
                obj.put("candidate", (Object)sdpObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return obj.toString();
        }
    }
}

