/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.common;

public class CGRectUtil {
    public static String toStringWithRect(CGRect rect) {
        return "X:" + rect.x + " Y:" + rect.y + " Width:" + rect.width + " Height:" + rect.height;
    }

    public static CGRect adjustFitScreenFrame(CGRect frame, CGRect superFrame) {
        if (superFrame.width == 0.0f || superFrame.height == 0.0f) {
            return new CGRect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float wScale = frame.width / superFrame.width;
        float hScale = frame.height / superFrame.height;
        if (wScale > hScale) {
            float width = superFrame.width;
            float height = superFrame.width / frame.width * frame.height;
            return new CGRect(0.0f, -(height - superFrame.height) / 2.0f, width, height);
        }
        if (wScale < hScale) {
            float width = superFrame.height / frame.height * frame.width;
            float height = superFrame.height;
            return new CGRect(-(width - superFrame.width) / 2.0f, 0.0f, width, height);
        }
        superFrame.x = 0.0f;
        superFrame.y = 0.0f;
        return superFrame;
    }

    public static CGRect adjustFillScreenFrame(CGRect frame, CGRect superFrame) {
        if (superFrame.width == 0.0f || superFrame.height == 0.0f) {
            return new CGRect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float wScale = frame.width / superFrame.width;
        float hScale = frame.height / superFrame.height;
        if (wScale > hScale) {
            float width = superFrame.height / frame.height * frame.width;
            float height = superFrame.height;
            return new CGRect(-(width - superFrame.width) / 2.0f, 0.0f, width, height);
        }
        if (wScale < hScale) {
            float width = superFrame.width;
            float height = superFrame.width / frame.width * frame.height;
            return new CGRect(0.0f, -(height - superFrame.height) / 2.0f, width, height);
        }
        superFrame.x = 0.0f;
        superFrame.y = 0.0f;
        return superFrame;
    }

    public static class CGRect {
        public float x;
        public float y;
        public float width;
        public float height;

        public CGRect(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

