/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.vhall.vhallrtc.client.ByteBufferMemoryPool;
import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.gles.EglCore;
import com.vhall.vhallrtc.gles.OffscreenSurface;
import com.vhall.vhallrtc.gpuimage.GPUImageBaseParamFilter;
import com.vhall.vhallrtc.gpuimage.GPUImageBeautifyFilter;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;
import com.vhall.vhallrtc.gpuimage.GPUImageFilterGroup;
import com.vhall.vhallrtc.gpuimage.OpenGlUtils;
import com.vhall.vhallrtc.gpuimage.Rotation;
import com.vhall.vhallrtc.gpuimage.TextureRotationUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class VHBeautifyFilter
extends Thread {
    private static final String mTag = "GlVideoRender";
    public static final int NO_IMAGE = -1;
    private int mInWidth = 0;
    private int mInHeight = 0;
    private boolean mFilterEn = false;
    private Rotation mRotation = Rotation.NORMAL;
    private boolean mFlipHorizontal = false;
    private boolean mFlipVertical = false;
    private Object mLock = null;
    private Handler mHandler = null;
    private int[] mFbo = null;
    private int[] mFbTexture = null;
    private EglCore mEglCore = null;
    private OffscreenSurface mOffscreenSurface = null;
    private FloatBuffer mVerCoordArray = null;
    private FloatBuffer mTexCoordArray = null;
    private GPUImageFilter mCameraInputFilter = null;
    private GPUImageFilterGroup mFilterGroup = null;
    private GPUImageBaseParamFilter mBaseFilter = null;
    private GPUImageBeautifyFilter mBeautifyFilter = null;
    private ExecutorService mYuv2RGBAThreadExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService mRGBA2YuvThreadExecutor = Executors.newSingleThreadExecutor();
    private OnDataReceivedListener mReceivedListener = null;
    private boolean enableCaptureCallback = false;
    private ByteBufferMemoryPool mByteBufferMemoryPool = new ByteBufferMemoryPool(10);
    private VideoCaptureCallback mVideoCaptureCallback = null;
    private ByteBuffer mGLRenderBuffer;
    private static final int GL_RENDER_DRAW_FRAME = 3;
    private static final int GL_RENDER_QUIT = 4;
    private ByteBuffer mRgbaInBuffer = null;
    private ByteBuffer mYuv420spInBuffer = null;
    private AtomicInteger yuvRunnableCount = new AtomicInteger(0);
    private ByteBuffer mRgbaOutBuffer = null;
    private AtomicInteger rgbaRunnableCount = new AtomicInteger(0);

    public VHBeautifyFilter(int inWidth, int inHeight) {
        if (inWidth <= 0 || inHeight <= 0) {
            throw new RuntimeException("Invalid parameters");
        }
        this.mInWidth = inWidth;
        this.mInHeight = inHeight;
        this.mLock = new Object();
    }

    public void setEnableCaptureCallback(boolean enable, VideoCaptureCallback callback) {
        this.enableCaptureCallback = enable;
        this.mVideoCaptureCallback = callback;
    }

    public void setReceivedListener(OnDataReceivedListener receivedListener) {
        this.mReceivedListener = receivedListener;
    }

    private void glesStart() {
        this.mEglCore = new EglCore(null, 1);
        this.mOffscreenSurface = new OffscreenSurface(this.mEglCore, this.mInWidth, this.mInHeight);
        this.mOffscreenSurface.makeCurrent();
        Log.d((String)mTag, (String)("GL_RENDERER: " + GLES20.glGetString((int)7937)));
        Log.d((String)mTag, (String)("GL_VENDOR: " + GLES20.glGetString((int)7936)));
        Log.d((String)mTag, (String)("GL_VERSION: " + GLES20.glGetString((int)7938)));
        Log.d((String)mTag, (String)("GL_EXTENSIONS: " + GLES20.glGetString((int)7939)));
        GLES20.glEnable((int)2884);
        GLES20.glCullFace((int)1029);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClearDepthf((float)1.0f);
        this.mVerCoordArray = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTexCoordArray = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mFbTexture = new int[2];
        GLES20.glGenTextures((int)2, (int[])this.mFbTexture, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mFbTexture[0]);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mInWidth, (int)this.mInHeight, (int)0, (int)6408, (int)5121, null);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mFbTexture[1]);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mInWidth, (int)this.mInHeight, (int)0, (int)6408, (int)5121, null);
        this.mFbo = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])this.mFbo, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFbo[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFbTexture[0], (int)0);
        if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
            Log.e((String)mTag, (String)("glCheckFramebufferStatus " + GLES20.glGetString((int)GLES20.glGetError())));
        } else {
            Log.d((String)mTag, (String)"glCheckFramebufferStatus success");
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        this.mCameraInputFilter = new GPUImageFilter();
        this.mCameraInputFilter.init();
        this.mBaseFilter = new GPUImageBaseParamFilter();
        this.mBeautifyFilter = new GPUImageBeautifyFilter(this.mInWidth, this.mInHeight);
        this.mFilterGroup = new GPUImageFilterGroup();
        this.mFilterGroup.addFilter(this.mBaseFilter);
        if (this.mFilterEn) {
            this.mFilterGroup.addFilter(this.mBeautifyFilter);
        }
        this.mFilterGroup.init();
        this.mBaseFilter.setBrightness(0.0f);
        this.mBaseFilter.setContrast(1.05f);
        this.mBaseFilter.setSaturation(1.05f);
        this.mFilterGroup.onOutputSizeChanged(this.mInWidth, this.mInHeight);
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.mRotation = rotation;
        this.mFlipHorizontal = flipHorizontal;
        this.mFlipVertical = flipVertical;
    }

    @SuppressLint(value={"WrongCall"})
    private void glesDrawView(ByteBuffer data, int width, int height) {
        if (this.mEglCore == null || this.mOffscreenSurface == null) {
            throw new RuntimeException("GlImageRender not prepared");
        }
        this.mFbTexture[1] = OpenGlUtils.loadTexture(data, width, height, this.mFbTexture[1]);
        float[] vercoord = GPUImageFilter.VERTEX_CUBE_NORMAL;
        float[] texcoord = TextureRotationUtil.getRotation(Rotation.NORMAL, false, false);
        float[] texcoord_in = TextureRotationUtil.getRotation(this.mRotation, this.mFlipHorizontal, this.mFlipVertical);
        this.mOffscreenSurface.makeCurrent();
        this.mVerCoordArray.position(0);
        this.mTexCoordArray.position(0);
        this.mVerCoordArray.put(vercoord).position(0);
        this.mTexCoordArray.put(texcoord_in).position(0);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFbo[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFbTexture[0], (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mInWidth, (int)this.mInHeight);
        GLES20.glClear((int)16640);
        this.mCameraInputFilter.onOutputSizeChanged(this.mInWidth, this.mInHeight);
        this.mCameraInputFilter.onDraw(this.mFbTexture[1], this.mVerCoordArray, this.mTexCoordArray);
        int src_tex = this.mFbTexture[0];
        int dst_tex = this.mFbTexture[1];
        if (this.enableCaptureCallback && this.mVideoCaptureCallback != null) {
            src_tex = this.mVideoCaptureCallback.onVideoCaptureCallback(this.mInWidth, this.mInHeight, src_tex);
            Log.d((String)mTag, (String)("src_tex: " + src_tex + " dst_tex: " + dst_tex + " android.os.Process.myTid()\uff1a " + Process.myTid()));
        }
        if (this.mFilterGroup.getMergedFilters() != null && this.mFilterGroup.getMergedFilters().size() > 0) {
            this.mVerCoordArray.position(0);
            this.mTexCoordArray.position(0);
            this.mVerCoordArray.put(vercoord).position(0);
            this.mTexCoordArray.put(texcoord).position(0);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)dst_tex, (int)0);
            GLES20.glViewport((int)0, (int)0, (int)this.mInWidth, (int)this.mInHeight);
            GLES20.glClear((int)16640);
            this.mFilterGroup.onDraw(src_tex, this.mVerCoordArray, this.mTexCoordArray);
            Log.d((String)mTag, (String)"mFilterGroup.onDraw");
            int tmp = src_tex;
            src_tex = dst_tex;
            dst_tex = tmp;
        }
        if (this.mGLRenderBuffer == null) {
            this.mGLRenderBuffer = ByteBuffer.allocate(this.mInWidth * this.mInHeight * 4);
        }
        GLES20.glReadPixels((int)0, (int)0, (int)this.mInWidth, (int)this.mInWidth, (int)6408, (int)5121, (Buffer)this.mGLRenderBuffer);
        this.videoTransform(width, height, this.mGLRenderBuffer);
    }

    private void glesStop() {
        this.mFilterGroup.destroy();
        this.mCameraInputFilter.destroy();
        this.mFilterGroup = null;
        this.mCameraInputFilter = null;
        this.mBaseFilter = null;
        this.mBeautifyFilter = null;
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glDeleteTextures((int)2, (int[])this.mFbTexture, (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])this.mFbo, (int)0);
        this.mFbTexture = null;
        this.mFbo = null;
        this.mOffscreenSurface.release();
        this.mEglCore.release();
        this.mOffscreenSurface = null;
        this.mEglCore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.glesStart();
        Looper.prepare();
        this.mHandler = new Handler(){
            long prevTime = System.currentTimeMillis();
            long frameCnt = 0L;

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 3: {
                        long ts0 = System.currentTimeMillis();
                        if (msg.obj != null && msg.obj instanceof ByteBuffer) {
                            ByteBuffer data = (ByteBuffer)msg.obj;
                            int width = msg.arg1;
                            int height = msg.arg2;
                            VHBeautifyFilter.this.glesDrawView(data, width, height);
                        }
                        long ts1 = System.currentTimeMillis();
                        ++this.frameCnt;
                        if (System.currentTimeMillis() < this.prevTime + 1000L) break;
                        Log.d((String)VHBeautifyFilter.mTag, (String)("size: " + VHBeautifyFilter.this.mInWidth + "x" + VHBeautifyFilter.this.mInHeight + " fps: " + this.frameCnt + " (" + (ts1 - ts0) + "ms)"));
                        this.prevTime += 1000L;
                        this.frameCnt = 0L;
                        break;
                    }
                    case 4: {
                        Looper.myLooper().quit();
                    }
                }
            }
        };
        Log.i((String)mTag, (String)"initialize success!");
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notify();
        }
        Looper.loop();
        this.glesStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        this.start();
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setFilterEnable(boolean en) {
        this.mFilterEn = en;
    }

    public void setBeautifyLevel(int level) {
        int n = level < 0 ? 0 : (level = level > 4 ? 4 : level);
        if (null != this.mBeautifyFilter) {
            this.mBeautifyFilter.setBeautifyLevel(level);
        }
    }

    public void setSaturation(int sat) {
        int n = sat < 0 ? 0 : (sat = sat > 100 ? 100 : sat);
        if (null != this.mBaseFilter) {
            this.mBaseFilter.setSaturation((float)sat / 50.0f);
        }
    }

    public void processVideoFrame(byte[] data, int width, int height) {
        if (this.mYuv2RGBAThreadExecutor.isShutdown()) {
            return;
        }
        if (this.yuvRunnableCount.get() > 1) {
            return;
        }
        YUVTransformRunnable runnable = new YUVTransformRunnable(data, width, height);
        this.mYuv2RGBAThreadExecutor.execute(runnable);
    }

    private void videoTransform(int width, int height, ByteBuffer buffer) {
        if (this.mRGBA2YuvThreadExecutor.isShutdown()) {
            return;
        }
        if (this.rgbaRunnableCount.get() > 1) {
            return;
        }
        RGBATransformRunnable runnable = new RGBATransformRunnable(width, height, buffer);
        this.mRGBA2YuvThreadExecutor.execute(runnable);
    }

    public void release() {
        this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)4));
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.mYuv2RGBAThreadExecutor.isShutdown()) {
            this.mYuv2RGBAThreadExecutor.shutdown();
        }
        if (!this.mRGBA2YuvThreadExecutor.isShutdown()) {
            this.mRGBA2YuvThreadExecutor.shutdown();
        }
        if (this.mByteBufferMemoryPool != null) {
            this.mByteBufferMemoryPool.clear();
        }
    }

    private class RGBATransformRunnable
    implements Runnable {
        private int width;
        private int height;

        public RGBATransformRunnable(int width, int height, ByteBuffer rgba) {
            this.width = width;
            this.height = height;
            if (VHBeautifyFilter.this.mRgbaOutBuffer == null) {
                VHBeautifyFilter.this.mRgbaOutBuffer = ByteBuffer.allocate(width * height * 4);
            }
            System.arraycopy(rgba.array(), 0, VHBeautifyFilter.this.mRgbaOutBuffer.array(), 0, rgba.capacity());
            VHBeautifyFilter.this.rgbaRunnableCount.getAndIncrement();
        }

        @Override
        public void run() {
            byte[] yuv420spOutBuffer = VHBeautifyFilter.this.mByteBufferMemoryPool.getByteBuffer(this.width * this.height * 3 / 2);
            if (yuv420spOutBuffer == null) {
                Log.w((String)VHBeautifyFilter.mTag, (String)"yuv420spOutBuffer == null");
                return;
            }
            SignalingChannel.ConvertABGR8888ToYUV420SP(VHBeautifyFilter.this.mRgbaOutBuffer.array(), yuv420spOutBuffer, this.width, this.height);
            if (VHBeautifyFilter.this.mReceivedListener != null) {
                VHBeautifyFilter.this.mReceivedListener.onData(yuv420spOutBuffer, VHBeautifyFilter.this.mByteBufferMemoryPool);
            }
            VHBeautifyFilter.this.rgbaRunnableCount.getAndDecrement();
        }
    }

    private class YUVTransformRunnable
    implements Runnable {
        private int width;
        private int height;

        public YUVTransformRunnable(byte[] data, int width, int height) {
            this.width = width;
            this.height = height;
            if (VHBeautifyFilter.this.mYuv420spInBuffer == null) {
                VHBeautifyFilter.this.mYuv420spInBuffer = ByteBuffer.allocate(width * height * 3 / 2);
            }
            System.arraycopy(data, 0, VHBeautifyFilter.this.mYuv420spInBuffer.array(), 0, VHBeautifyFilter.this.mYuv420spInBuffer.capacity());
            VHBeautifyFilter.this.yuvRunnableCount.getAndIncrement();
        }

        @Override
        public void run() {
            if (VHBeautifyFilter.this.mRgbaInBuffer == null) {
                VHBeautifyFilter.this.mRgbaInBuffer = ByteBuffer.allocate(this.width * this.height * 4);
            }
            SignalingChannel.YUV420spToRBGA(VHBeautifyFilter.this.mYuv420spInBuffer.array(), VHBeautifyFilter.this.mRgbaInBuffer.array(), this.width, this.height);
            VHBeautifyFilter.this.mHandler.sendMessage(Message.obtain((Handler)VHBeautifyFilter.this.mHandler, (int)3, (int)this.width, (int)this.height, (Object)VHBeautifyFilter.this.mRgbaInBuffer));
            VHBeautifyFilter.this.yuvRunnableCount.getAndDecrement();
        }
    }

    public static interface VideoCaptureCallback {
        public int onVideoCaptureCallback(int var1, int var2, int var3);
    }

    public static interface OnDataReceivedListener {
        public void onData(byte[] var1, ByteBufferMemoryPool var2);
    }
}

