/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.SignalingEvent;
import com.vhall.vhallrtc.common.EventDispatcher;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import com.vhall.vhallrtc.logreport.LogReport;
import com.vhall.vhallrtc.message.RespMsg;
import com.vhall.vhallrtc.message.SignalingMessage;
import com.vhall.vhallrtc.message.SignalingMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SignalingChannel
extends EventDispatcher {
    private static final String mTAG = "SignalingChannel";
    public static final String SignalingMessageVhall = "signaling_message_vhall";
    public static final String PublishMe = "publish_me";
    public static final String UnPublishMe = "unpublish_me";
    public static final String OnBandWithAlert = "onBandwidthAlert";
    public static final String OnDataStream = "onDataStream";
    public static final String OnUpdateAttributeStream = "onUpdateAttributeStream";
    public static final String OnRemoveStream = "onRemoveStream";
    public static final String OnAddStream = "onAddStream";
    public static final String OnAddInternalStream = "onAddInternalStream";
    public static final String OnRemoveInternalStream = "onRemoveInternalStream";
    public static final String OnInternalStreamFailed = "onInternalStreamFailed";
    public static final String ConnectionFailed = "connection_failed";
    public static final String Error = "error";
    public static final String Disconnect = "disconnect";
    public static final String BroadcastMuteStream = "broadcastMuteStream";
    public static final String OnRemoteUserQuitRoom = "remoteUserQuitRoom";
    public static final String OnStreamMixed = "onStreamMixed";
    public static final String Token = "token";
    public static final String Publish = "publish";
    public static final String UnPublish = "unpublish";
    public static final String Subscribe = "subscribe";
    public static final String UnSubscribe = "unsubscribe";
    public static final String SignalingMessagePeer = "signaling_message";
    public static final String UpdateStreamAttributes = "updateStreamAttributes";
    public static final String GetStreamStats = "getStreamStats";
    public static final String SendDataStream = "sendDataStream";
    public static final String SendMuteStream = "sendMuteStream";
    public static final String GetOverseas = "getOverseas";
    public static final String ConfigRoomBroadCast = "ConfigRoomBroadCast";
    public static final String SetMixLayoutMode = "SetMixLayoutMode";
    public static final String SetMixAdaptiveLayoutMode = "setMixAdaptiveLayoutMode";
    public static final String StartDocCloudRender = "startDocCloudRender";
    public static final String StopDocCloudRender = "stopDocCloudRender";
    public static final String SetMixLayoutMainScreen = "SetMixLayoutMainScreen";
    public static final String StartRoomBroadCast = "StartRoomBroadCast";
    public static final String StopRoomBroadCast = "StopRoomBroadCast";
    public static final String SetStreamMixOption = "setStreamMixOption";
    public static final String SetBackgroundImage = "setBackgroundImage";
    public static final String ResetBackgroundImage = "resetBackgroundImage";
    public static final String SetPlaceholderImage = "setPlaceholderImage";
    public static final String ResetPlaceholderImage = "resetPlaceholderImage";
    private long mNativeSignalingChannel = -1L;
    private SignalingChannelRoomDelegate mDeleagte = null;
    private JSONObject mRoomMetadata = null;
    private ExecutorService mSingleThread = Executors.newSingleThreadExecutor();
    private HashMap<String, VHSignalingChannelDelegate> mStreamSignalingDelegates = new HashMap();
    private HashMap<String, ArrayList<SignalingMessage>> mOutMessagesQueues = new HashMap();
    private EventCallback tokenCallback = new EventCallback(){

        @Override
        public void onResponse(final String resp) {
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            JSONArray object = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(object);
                            if (respMsg.getCode() == 200) {
                                SignalingChannel.this.mRoomMetadata = respMsg.getMsg();
                                if (SignalingChannel.this.mDeleagte != null) {
                                    SignalingChannel.this.mDeleagte.onSignalingChannelDidConnectToRoom(SignalingChannel.this, SignalingChannel.this.mRoomMetadata);
                                }
                            } else if (SignalingChannel.this.mDeleagte != null) {
                                SignalingChannel.this.mDeleagte.onSignalingChannelDidError(SignalingChannel.this, respMsg.getMessage());
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (SignalingChannel.this.mDeleagte == null) break block6;
                            SignalingChannel.this.mDeleagte.onSignalingChannelDidError(SignalingChannel.this, "json parser error.");
                        }
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onSignalingMessageVhall = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    JSONObject msg = null;
                    try {
                        msg = new JSONObject(socketEvent.mArgs);
                    }
                    catch (JSONException e) {
                        LogManager.e(SignalingChannel.mTAG, "" + msg.toString());
                        e.printStackTrace();
                    }
                    SignalingMessage message = SignalingMessage.messageFromJsonObject(msg);
                    if (message == null) {
                        return;
                    }
                    String key = SignalingChannel.this.keyForDelegate(message.streamId, message.peerSocketId);
                    VHSignalingChannelDelegate signalingDelegate = SignalingChannel.this.signalingDelegateForKey(key);
                    if (signalingDelegate == null && SignalingChannel.this.mDeleagte != null) {
                        signalingDelegate = SignalingChannel.this.mDeleagte.onClientDelegateRequiredForSignalingChannel(SignalingChannel.this);
                        signalingDelegate.streamId = message.streamId;
                        signalingDelegate.peerSocketId = message.peerSocketId;
                        SignalingChannel.this.setSignalingDelegate(signalingDelegate);
                    }
                    signalingDelegate.onDidReceiveMessage(message);
                    if (socketEvent.mType.equals(SignalingChannel.SignalingMessagePeer) && message.peerSocketId != null && message.type == SignalingMessageType.kVHSignalingMessageTypeOffer) {
                        signalingDelegate.onDidOpenChannel(SignalingChannel.this);
                        signalingDelegate.onReadyToSubscribe(message.streamId, message.peerSocketId);
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onDisconnect = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    JSONObject msg = null;
                    try {
                        msg = new JSONObject(socketEvent.mArgs);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (SignalingChannel.this.mDeleagte != null) {
                        SignalingChannel.this.mDeleagte.onSignalingChannelDidDisconnectToRoom(SignalingChannel.this, msg);
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onError = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (SignalingChannel.this.mDeleagte != null) {
                        SignalingChannel.this.mDeleagte.onSignalingChannelDidError(SignalingChannel.this, socketEvent.mArgs);
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onAddStreamMessage = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        SignalingEvent event = new SignalingEvent(socketEvent.mType, msg);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onDidStreamAdded(event.streamId, event);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onAddStreamMessage error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onAddInternalStreamMessage = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        SignalingEvent event = new SignalingEvent(socketEvent.mType, msg);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onDidInternalStreamAdded(event.streamId, event);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onDidInternalStreamAdded error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onRemoveInternalStreamMessage = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        SignalingEvent event = new SignalingEvent(socketEvent.mType, msg);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onDidInternalStreamRemoved(event.streamId, event);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onDidInternalStreamRemoved error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onInternalStreamFailedMessage = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        SignalingEvent event = new SignalingEvent(socketEvent.mType, msg);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onDidInternalStreamFailed(event.streamId, event);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onDidInternalStreamFailed error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onRemoveStreamMessage = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        VHSignalingChannelDelegate signalingDelegate;
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        String streamId = Tool.objectToString(msg.opt("id"));
                        String key = SignalingChannel.this.keyForDelegate(streamId, "");
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onDidRemovedStreamId(streamId);
                        }
                        if ((signalingDelegate = SignalingChannel.this.signalingDelegateForKey(key)) != null) {
                            signalingDelegate.onClosePeerConnection(SignalingChannel.this, streamId);
                        }
                        SignalingChannel.this.removeSignalingDelegateForKey(key);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onBroadcastMuteStream = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        String streamId = Tool.objectToString(msg.opt("id"));
                        JSONObject config = msg.optJSONObject("config");
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onUpdateMuteStream(streamId, config);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onBroadcastMuteStream error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onRemoteUserQuitRoom = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onRemoteUserQuitRoom(msg);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onRemoteUserQuitRoom error.");
                    }
                }
            });
        }
    };
    private EventDispatcher.Event onStreamMixed = new EventDispatcher.Event(){

        @Override
        public void dispatch(EventDispatcher.BaseEvent event) {
            final SocketEvent socketEvent = (SocketEvent)event;
            SignalingChannel.this.mSingleThread.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject msg = new JSONObject(socketEvent.mArgs);
                        if (SignalingChannel.this.mDeleagte != null) {
                            SignalingChannel.this.mDeleagte.onStreamMixed(msg);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LogManager.e(SignalingChannel.mTAG, "onRemoteUserQuitRoom error.");
                    }
                }
            });
        }
    };

    public SignalingChannel() {
        this.mNativeSignalingChannel = this.CreateSignalingChannel();
        this.addEventListerner(SignalingMessageVhall, this.onSignalingMessageVhall);
        this.addEventListerner(Disconnect, this.onDisconnect);
        this.addEventListerner(Error, this.onError);
        this.addEventListerner(OnAddStream, this.onAddStreamMessage);
        this.addEventListerner(OnAddInternalStream, this.onAddInternalStreamMessage);
        this.addEventListerner(OnRemoveInternalStream, this.onRemoveInternalStreamMessage);
        this.addEventListerner(OnInternalStreamFailed, this.onInternalStreamFailedMessage);
        this.addEventListerner(OnRemoveStream, this.onRemoveStreamMessage);
        this.addEventListerner(BroadcastMuteStream, this.onBroadcastMuteStream);
        this.addEventListerner(OnRemoteUserQuitRoom, this.onRemoteUserQuitRoom);
        this.addEventListerner(OnStreamMixed, this.onStreamMixed);
    }

    protected void finalize() throws Throwable {
        this.DestorySignalingChannel(this.mNativeSignalingChannel);
        super.finalize();
    }

    void setChannelDeleagte(SignalingChannelRoomDelegate delegate) {
        this.mDeleagte = delegate;
    }

    public void init(int attempts) {
        this.Init(attempts);
    }

    public boolean connect(String token) {
        this.mStreamSignalingDelegates = new HashMap();
        this.mOutMessagesQueues = new HashMap();
        int ret = this.Connect(token, this.tokenCallback);
        return ret == 0;
    }

    public void disconnect() {
        this.Disconnect();
        if (this.mStreamSignalingDelegates != null && this.mStreamSignalingDelegates.size() > 0) {
            for (VHSignalingChannelDelegate delegate : this.mStreamSignalingDelegates.values()) {
                if (delegate == null) continue;
                delegate.onClosePeerConnection(this, delegate.streamId);
            }
            this.mStreamSignalingDelegates.clear();
        }
        if (this.mOutMessagesQueues != null) {
            this.mOutMessagesQueues.clear();
        }
    }

    public void sendSignalingMessage(@NonNull SignalingMessage msg, final @Nullable FinishCallback finish) {
        if (msg.streamId == null) {
            LogManager.e(mTAG, "sending orphan signaling message, lack streamId");
        }
        JSONObject data = new JSONObject();
        try {
            data.put("streamId", (Object)msg.streamId);
            if (msg.peerSocketId != null) {
                data.put("peerSocket", (Object)msg.peerSocketId);
            }
            data.put("msg", (Object)msg.jsonObject());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendMessage(SignalingMessagePeer, data.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void enqueueSignalingMessage(SignalingMessage msg) {
        String key = this.keyForDelegate(msg.streamId, msg.peerSocketId);
        if (msg.type == SignalingMessageType.kVHSignalingMessageTypeAnswer || msg.type == SignalingMessageType.kVHSignalingMessageTypeOffer) {
            if (this.mOutMessagesQueues.containsKey(key)) {
                this.mOutMessagesQueues.get(key).add(0, msg);
            }
        } else if (this.mOutMessagesQueues.containsKey(key)) {
            this.mOutMessagesQueues.get(key).add(msg);
        }
    }

    public void drainMessageQueue(String streamId, String peerSocketId) {
        String key = this.keyForDelegate(streamId, peerSocketId);
        if (this.mOutMessagesQueues.containsKey(key)) {
            for (SignalingMessage message : this.mOutMessagesQueues.get(key)) {
                this.sendSignalingMessage(message, null);
            }
            this.mOutMessagesQueues.get(key).clear();
        }
    }

    public void publish(JSONObject option, final VHSignalingChannelDelegate channelDelegate) {
        if (!option.has("state")) {
            try {
                option.putOpt("state", (Object)"erizo");
            }
            catch (JSONException e) {
                LogManager.e(mTAG, "publish json put error.");
                e.printStackTrace();
            }
        }
        this.sendMessage(Publish, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        SignalingChannel.this.onPublishCallback(resp, channelDelegate);
                    }
                });
            }
        });
    }

    public void unpublish(final String streamId) {
        JSONObject option = new JSONObject();
        try {
            option.put("streamId", (Object)streamId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.SendMessage(UnPublish, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONArray argsData = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(argsData);
                            if (respMsg.getCode() == 200) {
                                String key = SignalingChannel.this.keyForDelegate(streamId, "");
                                SignalingChannel.this.removeSignalingDelegateForKey(key);
                                if (SignalingChannel.this.mDeleagte != null) {
                                    SignalingChannel.this.mDeleagte.onDidUnpublishStream(streamId, resp);
                                }
                            } else {
                                if (SignalingChannel.this.mDeleagte != null) {
                                    SignalingChannel.this.mDeleagte.onDidUnpublishStream(streamId, resp);
                                }
                                LogManager.e(SignalingChannel.mTAG, "signalingChannel Couldn't unpublish stream id: " + streamId);
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            LogManager.e(SignalingChannel.mTAG, "unpublish error.");
                        }
                    }
                });
            }
        });
    }

    public void unpublish(final String streamId, final FinishCallback callback) {
        if (streamId == null) {
            return;
        }
        String key = this.keyForDelegate(streamId, "");
        this.removeSignalingDelegateForKey(key);
        JSONObject option = new JSONObject();
        try {
            option.put("streamId", (Object)streamId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.SendMessage(UnPublish, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONArray argsData = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(argsData);
                            if (callback != null) {
                                callback.onFinish(respMsg.getCode(), respMsg.getMessage());
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (callback != null) {
                                callback.onFinish(-1, "JSONException.");
                            }
                            LogManager.e(SignalingChannel.mTAG, "unpublish error.");
                            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnpublishSignalingFail, streamId);
                        }
                    }
                });
            }
        });
    }

    public void subscribe(final String streamId, JSONObject option, final VHSignalingChannelDelegate channelDelegate) {
        if (option == null) {
            LogManager.e(mTAG, "option is null.");
            return;
        }
        this.sendMessage(Subscribe, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        SignalingChannel.this.onSubscribeCallback(streamId, resp, channelDelegate);
                    }
                });
            }
        });
    }

    public void unsubscribe(final String streamId) {
        JSONObject option = new JSONObject();
        try {
            option.put("streamId", (Object)streamId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendMessage(UnSubscribe, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONArray argsData = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(argsData);
                            if (respMsg.getCode() == 200) {
                                String key = SignalingChannel.this.keyForDelegate(streamId, "");
                                VHSignalingChannelDelegate clientDelegate = SignalingChannel.this.signalingDelegateForKey(key);
                                VHSignalingChannelDelegate signalingDelegate = SignalingChannel.this.signalingDelegateForKey(key);
                                if (signalingDelegate != null) {
                                    signalingDelegate.onClosePeerConnection(SignalingChannel.this, streamId);
                                }
                                SignalingChannel.this.removeSignalingDelegateForKey(key);
                                if (clientDelegate != null) {
                                    clientDelegate.onClosePeerConnection(SignalingChannel.this, clientDelegate.streamId);
                                }
                                if (SignalingChannel.this.mDeleagte != null) {
                                    SignalingChannel.this.mDeleagte.onDidUnsubscribeStream(streamId);
                                }
                            } else {
                                LogManager.e(SignalingChannel.mTAG, "signalingChannel Couldn't unsubscribe stream id: " + streamId);
                                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnsubcribeSignalingFail, streamId);
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            LogManager.e(SignalingChannel.mTAG, "unpublish error.");
                            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnsubcribeSignalingFail, streamId);
                        }
                    }
                });
            }
        });
    }

    public void unsubscribe(String streamId, final FinishCallback callback) {
        String key = this.keyForDelegate(streamId, "");
        this.removeSignalingDelegateForKey(key);
        JSONObject option = new JSONObject();
        try {
            option.put("streamId", (Object)streamId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendMessage(UnSubscribe, option.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONArray argsData = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(argsData);
                            if (callback != null) {
                                callback.onFinish(respMsg.getCode(), respMsg.getMessage());
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            if (callback != null) {
                                callback.onFinish(-1, "JSONException.");
                            }
                            LogManager.e(SignalingChannel.mTAG, "unsubscribe error.");
                        }
                    }
                });
            }
        });
    }

    public void sendMuteStream(String streamId, JSONObject config, final FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("streamId", (Object)streamId);
            JSONObject msg = new JSONObject();
            msg.put("type", (Object)"updatestream");
            msg.put("config", (Object)config);
            message.put("msg", (Object)msg);
            this.sendMessage(SignalingMessagePeer, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void switchDualStream(@NonNull String streamId, @NonNull int type, final @Nullable FinishCallback finish) {
        if (streamId == null || streamId.length() < 0) {
            LogManager.e(mTAG, "streamId is null.");
            return;
        }
        try {
            JSONObject message = new JSONObject();
            message.put("streamId", (Object)streamId);
            JSONObject msg = new JSONObject();
            msg.put("type", (Object)"updatestream");
            JSONObject config = new JSONObject();
            config.put("dual", type);
            msg.put("config", (Object)config);
            message.put("msg", (Object)msg);
            this.sendMessage(SignalingMessagePeer, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void configRoomBroadCast(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("config", (Object)config.toString());
            message.put("mode", (Object)(mode == null || mode.isEmpty() ? "mix" : mode));
            this.sendMessage(ConfigRoomBroadCast, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setMixAdpaptiveLayoutMode(@NonNull int adaptiveLayoutMode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("config", adaptiveLayoutMode);
            this.sendMessage(SetMixAdaptiveLayoutMode, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setMixLayoutMode(@NonNull int layoutMode, @Nullable String mode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("config", layoutMode);
            message.put("mode", (Object)(mode == null || mode.isEmpty() ? "mix" : mode));
            this.sendMessage(SetMixLayoutMode, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setMixLayoutMainScreen(@NonNull String streamId, @Nullable String mode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("config", (Object)streamId);
            message.put("mode", (Object)(mode == null || mode.isEmpty() ? "mix" : mode));
            this.sendMessage(SetMixLayoutMainScreen, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void startRoomBroadCast(@Nullable String mode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("mode", (Object)(mode == null || mode.isEmpty() ? "mix" : mode));
            this.sendMessage(StartRoomBroadCast, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void stopRoomBroadCast(@Nullable String mode, final @Nullable FinishCallback finish) {
        try {
            JSONObject message = new JSONObject();
            message.put("mode", (Object)(mode == null || mode.isEmpty() ? "mix" : mode));
            this.sendMessage(StopRoomBroadCast, message.toString(), new EventCallback(){

                @Override
                public void onResponse(final String resp) {
                    SignalingChannel.this.mSingleThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JSONArray argsData = new JSONArray(resp);
                                    RespMsg respMsg = new RespMsg(argsData);
                                    if (finish != null) {
                                        finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (finish == null) break block3;
                                    finish.onFinish(-1, "JSONException");
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRoomBroadCastMixOption(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        this.sendMessage(SetStreamMixOption, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void setRoomBroadCastBackgroundImage(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        this.sendMessage(SetBackgroundImage, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void reSetRoomBroadCastBackgroundImage(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        this.sendMessage(ResetBackgroundImage, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void setRoomBroadCastPlaceholderImage(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        this.sendMessage(SetPlaceholderImage, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void reSetRoomBroadCastPlaceholderImage(@NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        this.sendMessage(ResetPlaceholderImage, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMessage());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void startDocCloudRender(@NonNull JSONObject config, final @Nullable FinishCallback finish) {
        this.sendMessage(StartDocCloudRender, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMsg().toString());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void stopDocCloudRender(@NonNull JSONObject config, final @Nullable FinishCallback finish) {
        this.sendMessage(StopDocCloudRender, config.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JSONArray argsData = new JSONArray(resp);
                                RespMsg respMsg = new RespMsg(argsData);
                                if (finish != null) {
                                    finish.onFinish(respMsg.getCode(), respMsg.getMsg().toString());
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                if (finish == null) break block3;
                                finish.onFinish(-1, "JSONException");
                            }
                        }
                    }
                });
            }
        });
    }

    public void getOverseas(@NonNull String streamId, boolean isLocal, final OverseasCallback finish) {
        JSONObject message = new JSONObject();
        try {
            message.put("streamId", (Object)streamId);
            message.put("isSub", !isLocal);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendMessage(GetOverseas, message.toString(), new EventCallback(){

            @Override
            public void onResponse(final String resp) {
                SignalingChannel.this.mSingleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONArray argsData = new JSONArray(resp);
                            RespMsg respMsg = new RespMsg(argsData);
                            if (respMsg.getCode() == 200) {
                                boolean value = respMsg.getMsg().optBoolean("result");
                                if (finish != null) {
                                    finish.onFinish(value);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private void onPublishCallback(String resp, VHSignalingChannelDelegate delegate) {
        try {
            JSONArray argsData = new JSONArray(resp);
            RespMsg respMsg = new RespMsg(argsData);
            if (respMsg.getCode() == 200) {
                String streamId = Tool.objectToString(respMsg.getMsg().getString("streamId"));
                if (streamId == null) {
                    LogManager.e(mTAG, "streamId is not string or number type: ");
                    return;
                }
                delegate.streamId = streamId;
                this.setSignalingDelegate(delegate);
                if (this.mDeleagte != null) {
                    this.mDeleagte.onDidReceiveStreamIdReadyToPublish(this, streamId);
                }
                delegate.onDidOpenChannel(this);
                delegate.onReadyToPublish(streamId, null);
            } else {
                if (this.mDeleagte != null) {
                    this.mDeleagte.onSignalingChannelDidError(this, "onPublishCallback json pares error.");
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendPublishSignalingFail, null, "onPublishCallback json pares error.");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            if (this.mDeleagte != null) {
                this.mDeleagte.onSignalingChannelDidError(this, "onPublishCallback json pares error.");
            }
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendPublishSignalingFail, null, "onPublishCallback json pares error.");
        }
    }

    private void onSubscribeCallback(String streamId, String resp, VHSignalingChannelDelegate delegate) {
        try {
            JSONArray array = new JSONArray(resp);
            RespMsg respMsg = new RespMsg(array);
            if (respMsg.getCode() == 200) {
                delegate.streamId = streamId;
                this.setSignalingDelegate(delegate);
                delegate.onDidOpenChannel(this);
                delegate.onReadyToSubscribe(streamId, null);
                if (this.mDeleagte != null) {
                    this.mDeleagte.onDidSubscribedReadyToSubscribe(this, streamId);
                }
            } else {
                LogManager.e(mTAG, "SignalingChannel couldn't subscribe streamId: " + streamId);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendSubscribeSignalingFail, streamId, respMsg.getMessage());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            delegate.onClosePeerConnection(this, streamId);
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendSubscribeSignalingFail, streamId, "SubscribeCallback mag failed!");
            LogManager.e(mTAG, "subscribeCallback json parse error.");
        }
    }

    private boolean sendMessage(String type, String msg, EventCallback callback) {
        if (type == null || msg == null) {
            return false;
        }
        this.SendMessage(type, msg, callback);
        return true;
    }

    private boolean sendSdpMessage(String type, String msg, EventCallback callback) {
        if (type == null || msg == null) {
            return false;
        }
        this.SendSdpMessage(type, msg, callback);
        return true;
    }

    private void emit(String type, String args) {
        this.dispatchEvent(new SocketEvent(type, args));
    }

    private void removeSignalingDelegateForKey(String key) {
        if (this.mStreamSignalingDelegates.containsKey(key)) {
            this.mStreamSignalingDelegates.remove(key);
        }
    }

    private void setSignalingDelegate(VHSignalingChannelDelegate delegate) {
        String key = this.keyForDelegate(delegate);
        this.removeSignalingDelegateForKey(key);
        this.mStreamSignalingDelegates.put(key, delegate);
        this.mOutMessagesQueues.put(key, new ArrayList());
    }

    private String keyForDelegate(VHSignalingChannelDelegate delegate) {
        return this.keyForDelegate(delegate.streamId, delegate.peerSocketId);
    }

    private String keyForDelegate(String streamId, String peerSocketId) {
        return "" + streamId + peerSocketId;
    }

    private VHSignalingChannelDelegate signalingDelegateForKey(String key) {
        return this.mStreamSignalingDelegates.get(key);
    }

    private native long CreateSignalingChannel();

    private native void DestorySignalingChannel(long var1);

    private native void Init(int var1);

    private native int Connect(String var1, Object var2);

    private native void Disconnect();

    private native void SendMessage(String var1, String var2, Object var3);

    private native void SendSdpMessage(String var1, String var2, Object var3);

    public static native void EnabledebugLog(boolean var0);

    public static native String EnableSimulcast(String var0, int var1);

    public static native void ConvertABGRPlaneToData(byte[] var0, byte[] var1, int var2, int var3, int var4, int var5);

    public static native void ConvertABGR8888ToYUV420SP(byte[] var0, byte[] var1, int var2, int var3);

    public static native void YUV420spToRBGA(byte[] var0, byte[] var1, int var2, int var3);

    static {
        System.loadLibrary("vhallrtc_signaling_jni");
    }

    public class SocketEvent
    extends EventDispatcher.BaseEvent {
        public String mArgs;

        public SocketEvent(String type, String args) {
            super(SignalingChannel.this);
            this.mType = type;
            this.mArgs = args;
        }
    }

    public static interface OverseasCallback {
        public void onFinish(boolean var1);
    }

    public static interface EventCallback {
        public void onResponse(String var1);
    }

    public static abstract class VHSignalingChannelDelegate {
        public String streamId = null;
        public String peerSocketId = null;

        public abstract void onDidOpenChannel(SignalingChannel var1);

        public abstract void onPublishFailed(SignalingChannel var1);

        public abstract void onReadyToPublish(String var1, String var2);

        public abstract void onReadyToSubscribe(String var1, String var2);

        public abstract void onDidReceiveMessage(SignalingMessage var1);

        public abstract void onClosePeerConnection(SignalingChannel var1, String var2);
    }

    public static interface SignalingChannelRoomDelegate {
        public void onDidReceiveStreamIdReadyToPublish(SignalingChannel var1, String var2);

        public void onDidSubscribedReadyToSubscribe(SignalingChannel var1, String var2);

        public void onSignalingChannelDidError(SignalingChannel var1, String var2);

        public void onSignalingChannelDidConnectToRoom(SignalingChannel var1, JSONObject var2);

        public VHSignalingChannelDelegate onClientDelegateRequiredForSignalingChannel(SignalingChannel var1);

        public void onSignalingChannelDidDisconnectToRoom(SignalingChannel var1, JSONObject var2);

        public void onDidStreamAdded(String var1, SignalingEvent var2);

        public void onDidInternalStreamAdded(String var1, SignalingEvent var2);

        public void onDidInternalStreamRemoved(String var1, SignalingEvent var2);

        public void onDidInternalStreamFailed(String var1, SignalingEvent var2);

        public void onDidRemovedStreamId(String var1);

        public void onDidUnsubscribeStream(String var1);

        public void onDidUnpublishStream(String var1, String var2);

        public void onUpdateMuteStream(String var1, JSONObject var2);

        public void onRemoteUserQuitRoom(JSONObject var1);

        public void onStreamMixed(JSONObject var1);
    }
}

