/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.WindowManager;
import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.common.LogManager;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.vhwebrtc.CapturerObserver;
import org.vhwebrtc.NV21Buffer;
import org.vhwebrtc.SurfaceTextureHelper;
import org.vhwebrtc.VideoCapturer;
import org.vhwebrtc.VideoFrame;

public class ScreenRecorder
implements VideoCapturer {
    private static final String mTAG = "ScreenRecorder";
    private int mWidth;
    private int mHeight;
    private int mDpi;
    private int mFrameRate;
    private Timer mStatsTimer;
    private TimerTask timerTask;
    private long period;
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private final Object mMutex = new Object();
    private HandlerThread mHandlerThread;
    private long mLastSendTSMs;
    private int mOrientation = -1;
    private MediaProjection mMediaProjection;
    private ImageReader mImgReader;
    private Handler mHandler;
    private AtomicBoolean mQuit = new AtomicBoolean(false);
    private VirtualDisplay mVirtualDisplay = null;
    private byte[] inputData = null;
    private byte[] bufferData = null;
    private byte[] outputData = null;
    VideoFrame mVideoFrame = null;
    private Runnable vhrun = new Runnable(){

        @Override
        public void run() {
            ScreenRecorder.this.changeCaptureFormat(ScreenRecorder.this.mWidth, ScreenRecorder.this.mHeight, ScreenRecorder.this.mFrameRate);
        }
    };

    public ScreenRecorder(int dpi, MediaProjection mp) {
        this.mDpi = dpi;
        this.mMediaProjection = mp;
        this.mHandlerThread = new HandlerThread("HandlerThread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mLastSendTSMs = 0L;
    }

    @RequiresApi(api=21)
    private void initImageReader(int width, int height, int frameRate) {
        this.mImgReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)1, (int)3);
        this.mImgReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader reader) {
            }
        }, this.mHandler);
    }

    @RequiresApi(api=21)
    private void createVirtualDisplay(int width, int height) {
        this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("ScreenRecorder-display", width, height, this.mDpi, 1, this.mImgReader.getSurface(), null, null);
    }

    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    public void startCapture(int width, int height, int framerate) {
        this.heavySet(width, height);
        LogManager.d(mTAG, "startCapture: " + width + "x" + height + "@" + framerate);
        if (this.applicationContext == null) {
            throw new RuntimeException("ScreenRecorder must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.mFrameRate = framerate;
            this.period = 1000 / this.mFrameRate;
            this.bufferData = null;
            this.inputData = new byte[width * height * 4];
            this.outputData = new byte[width * height * 3 / 2];
            this.initImageReader(this.mWidth, this.mHeight, framerate);
            this.createVirtualDisplay(this.mWidth, this.mHeight);
            if (this.capturerObserver != null) {
                this.capturerObserver.onCapturerStarted(true);
            }
            if (this.mStatsTimer == null) {
                this.mStatsTimer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        ScreenRecorder.this.myrun();
                    }
                };
                this.mStatsTimer.schedule(this.timerTask, this.period, this.period);
            }
        }
        this.mQuit.set(false);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long preTS = 0L;
                long intervalTS = 120L;
                while (!ScreenRecorder.this.mQuit.get()) {
                    long startTS = System.currentTimeMillis();
                    if (preTS == 0L) {
                        preTS = startTS;
                    }
                    if (startTS - ScreenRecorder.this.mLastSendTSMs > 500L && ScreenRecorder.this.capturerObserver != null) {
                        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                        NV21Buffer frameBuffer = new NV21Buffer(ScreenRecorder.this.outputData, ScreenRecorder.this.mWidth, ScreenRecorder.this.mHeight, null);
                        VideoFrame frame = new VideoFrame((VideoFrame.Buffer)frameBuffer, 0, captureTimeNs);
                        if (ScreenRecorder.this.capturerObserver != null) {
                            ScreenRecorder.this.capturerObserver.onFrameCaptured(frame);
                        }
                        frame.release();
                    }
                    long diffTS = startTS - preTS;
                    long waitTime = Math.max(intervalTS + intervalTS - diffTS, 0L);
                    Object object = ScreenRecorder.this.mMutex;
                    synchronized (object) {
                        try {
                            waitTime = Math.max(waitTime, 50L);
                            ScreenRecorder.this.mMutex.wait(waitTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            LogManager.w(ScreenRecorder.mTAG, e.toString());
                        }
                    }
                    preTS = startTS;
                }
            }
        });
        thread.start();
    }

    public void myrun() {
        try {
            Image img = this.mImgReader.acquireLatestImage();
            if (img != null) {
                Image.Plane[] planes = img.getPlanes();
                if (planes[0].getBuffer() == null) {
                    return;
                }
                int width = this.mImgReader.getWidth();
                int height = this.mImgReader.getHeight();
                int pixelStride = planes[0].getPixelStride();
                int rowStride = planes[0].getRowStride();
                int rowPadding = rowStride - pixelStride * width;
                ByteBuffer buffer = planes[0].getBuffer();
                if (rowPadding > 0) {
                    if (this.bufferData == null) {
                        this.bufferData = new byte[buffer.capacity()];
                    }
                    buffer.get(this.bufferData);
                    SignalingChannel.ConvertABGRPlaneToData(this.bufferData, this.inputData, width, height, pixelStride, rowPadding);
                } else {
                    buffer.get(this.inputData);
                }
                SignalingChannel.ConvertABGR8888ToYUV420SP(this.inputData, this.outputData, width, height);
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                NV21Buffer frameBuffer = new NV21Buffer(this.outputData, width, height, null);
                Log.d((String)mTAG, (String)("onImageAvailable:" + captureTimeNs));
                this.mVideoFrame = new VideoFrame((VideoFrame.Buffer)frameBuffer, 0, captureTimeNs);
                if (this.capturerObserver != null) {
                    this.capturerObserver.onFrameCaptured(this.mVideoFrame);
                    this.mLastSendTSMs = System.currentTimeMillis();
                }
                if (this.getDeviceOrientation() != this.mOrientation) {
                    this.mOrientation = this.getDeviceOrientation();
                    this.mHandler.post(this.vhrun);
                }
                img.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    public void stopCapture() {
        Object object = this.stateLock;
        synchronized (object) {
            this.mQuit.set(true);
            Object object2 = this.mMutex;
            synchronized (object2) {
                this.mMutex.notify();
            }
            if (this.mStatsTimer != null) {
                this.mStatsTimer.cancel();
                this.mStatsTimer = null;
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
                this.mVirtualDisplay = null;
            }
            if (this.mImgReader != null) {
                this.mImgReader.close();
                this.mImgReader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCaptureFormat(int width, int height, int framerate) {
        LogManager.d(mTAG, "changeCaptureFormat: " + width + "x" + height + "@" + framerate);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(width, height, framerate);
        }
    }

    @RequiresApi(value=21)
    public void dispose() {
        this.stopCapture();
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread = null;
        }
    }

    public boolean isScreencast() {
        return true;
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            default: {
                orientation = 0;
                break;
            }
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
            }
        }
        return orientation;
    }

    private void heavySet(int width, int height) {
        this.mOrientation = this.getDeviceOrientation();
        if (this.mOrientation == 0 || this.mOrientation == 180) {
            this.mWidth = Math.min(width, height);
            this.mHeight = Math.max(width, height);
        } else {
            this.mWidth = Math.max(width, height);
            this.mHeight = Math.min(width, height);
        }
    }
}

