/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import java.util.HashMap;
import java.util.LinkedList;

public class ByteBufferMemoryPool {
    private int mMaxCount = 10;
    private static final String mTAG = "ByteBufferMemoryPool";
    private HashMap<byte[], byte[]> usedMap = new HashMap();
    private LinkedList<byte[]> freeLsit = new LinkedList();

    public ByteBufferMemoryPool(int max) {
        this.mMaxCount = max;
    }

    public synchronized byte[] getByteBuffer(int size) {
        byte[] buffer;
        if (this.usedMap.size() + this.freeLsit.size() > this.mMaxCount) {
            return null;
        }
        while (!this.freeLsit.isEmpty()) {
            buffer = this.freeLsit.pollFirst();
            if (buffer.length != size) continue;
            this.usedMap.put(buffer, buffer);
            return buffer;
        }
        if (this.freeLsit.isEmpty()) {
            buffer = new byte[size];
            this.usedMap.put(buffer, buffer);
            return buffer;
        }
        return null;
    }

    public synchronized void releaseBuffer(byte[] buffer) {
        if (this.usedMap.containsKey(buffer)) {
            this.usedMap.remove(buffer);
        }
        if (!this.freeLsit.contains(buffer)) {
            this.freeLsit.push(buffer);
        }
    }

    public synchronized void clear() {
        this.usedMap.clear();
        this.freeLsit.clear();
    }
}

