/*
 * Decompiled with CFR 0.152.
 */
package org.vhwebrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import org.vhwebrtc.AndroidVideoDecoder;
import org.vhwebrtc.EglBase;
import org.vhwebrtc.Logging;
import org.vhwebrtc.MediaCodecUtils;
import org.vhwebrtc.MediaCodecWrapperFactoryImpl;
import org.vhwebrtc.Predicate;
import org.vhwebrtc.VideoCodecInfo;
import org.vhwebrtc.VideoCodecMimeType;
import org.vhwebrtc.VideoDecoder;
import org.vhwebrtc.VideoDecoderFactory;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    private VideoDecoder.VideoDecoderEventCallback mVideoDecoderEventCallback;

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate) {
        this(sharedContext, null, codecAllowedPredicate);
    }

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext, VideoDecoder.VideoDecoderEventCallback callback, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate) {
        this.sharedContext = sharedContext;
        this.codecAllowedPredicate = codecAllowedPredicate;
        this.mVideoDecoderEventCallback = callback;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoCodecMimeType type = VideoCodecMimeType.valueOf(codecType.getName());
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(type.mimeType());
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), type, MediaCodecUtils.selectColorFormat(info.getName(), false, MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities), this.sharedContext, this.mVideoDecoderEventCallback);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecMimeType type : new VideoCodecMimeType[]{VideoCodecMimeType.H264, VideoCodecMimeType.VP8, VideoCodecMimeType.VP9}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecMimeType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecMimeType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }
            if (info == null || info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecMimeType type) {
        String name = info.getName();
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        return MediaCodecUtils.selectColorFormat(info.getName(), false, MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) != null;
    }

    private boolean isCodecAllowed(MediaCodecInfo info) {
        if (this.codecAllowedPredicate == null) {
            return true;
        }
        return this.codecAllowedPredicate.test(info);
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.")) {
            return true;
        }
        return true;
    }
}

