/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.chat;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMSDKConfig;
import com.tencent.imsdk.v2.V2TIMSDKListener;
import com.tencent.imsdk.v2.V2TIMSimpleMsgListener;
import com.vhall.chat.ConnectServerV2;
import com.vhall.chat.VHChatServerV2Def;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ChatServerV2
implements ConnectServerV2 {
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private VHChatServerV2Def.ConnectConfigInfo mConfig;
    private static final String TAG = "ChatServerV2";
    private ConnectServerV2.EventCallback mCallback = null;
    private ConnectServerV2.NetState mState = ConnectServerV2.NetState.STATE_DISCONNECT;
    private V2TIMSDKListener mTIMSDKListener = null;
    private V2TIMSimpleMsgListener mSimpleMsgListener = null;
    private boolean mIsGroupJoined = false;
    private boolean mNetworkConnected = false;
    private V2TIMSDKConfig mSDKConfig = new V2TIMSDKConfig();
    private int mJoinGroupCount = 0;

    private boolean init(Context context, int sdkAppId) {
        if (this.mTIMSDKListener == null) {
            this.mTIMSDKListener = new V2TIMSDKListener(){

                public void onConnecting() {
                    super.onConnecting();
                    ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_CONNECTING;
                    ChatServerV2.this.mNetworkConnected = false;
                    Log.i((String)"imsdk", (String)"onConnecting");
                    if (ChatServerV2.this.mCallback != null) {
                        ChatServerV2.this.mCallback.onStateChanged(ConnectServerV2.NetState.STATE_CONNECTING);
                    }
                }

                public void onConnectSuccess() {
                    super.onConnectSuccess();
                    ChatServerV2.this.mNetworkConnected = true;
                    Log.i((String)"imsdk", (String)"onConnectSuccess");
                    if (ChatServerV2.this.mCallback != null && ChatServerV2.this.mIsGroupJoined) {
                        ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_CONNECTED;
                        ChatServerV2.this.mCallback.onStateChanged(ConnectServerV2.NetState.STATE_CONNECTED);
                    }
                }

                public void onConnectFailed(int code, String error) {
                    super.onConnectFailed(code, error);
                    Log.i((String)"imsdk", (String)"onConnectFailed");
                    ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
                    ChatServerV2.this.mNetworkConnected = false;
                    if (ChatServerV2.this.mCallback != null) {
                        ChatServerV2.this.mCallback.onStateChanged(ConnectServerV2.NetState.STATE_DISCONNECT);
                    }
                }

                public void onKickedOffline() {
                    Log.i((String)"imsdk", (String)"onKickedOffline");
                    ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_KICK_OFF;
                    ChatServerV2.this.mNetworkConnected = false;
                    if (ChatServerV2.this.mCallback != null) {
                        ChatServerV2.this.mCallback.onStateChanged(ConnectServerV2.NetState.STATE_KICK_OFF);
                    }
                }

                public void onUserSigExpired() {
                    super.onUserSigExpired();
                    ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
                    if (ChatServerV2.this.mCallback != null) {
                        ChatServerV2.this.mCallback.onStateChanged(ConnectServerV2.NetState.STATE_SIG_EXPIRED);
                    }
                }
            };
        }
        if (this.mSimpleMsgListener == null) {
            this.mSimpleMsgListener = new V2TIMSimpleMsgListener(){

                public void onRecvGroupTextMessage(String msgID, String groupID, V2TIMGroupMemberInfo sender, String text) {
                    for (Map.Entry<String, String> entry : ((ChatServerV2)ChatServerV2.this).mConfig.group_list.entrySet()) {
                        String group_id = entry.getKey();
                        if (!groupID.equals(group_id) || ChatServerV2.this.mCallback == null) continue;
                        ChatServerV2.this.mCallback.onMsg(groupID, text);
                    }
                }

                public void onRecvGroupCustomMessage(String msgID, String groupID, V2TIMGroupMemberInfo sender, byte[] customData) {
                    for (Map.Entry<String, String> entry : ((ChatServerV2)ChatServerV2.this).mConfig.group_list.entrySet()) {
                        String group_id = entry.getKey();
                        if (!groupID.equals(group_id) || ChatServerV2.this.mCallback == null) continue;
                        String text = null;
                        try {
                            text = new String(customData, "UTF-8");
                            ChatServerV2.this.mCallback.onMsg(groupID, text);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            Log.i((String)"imsdk", (String)"onRecvGroupCustomMessage error ");
                        }
                    }
                }
            };
        }
        this.mSDKConfig.setLogLevel(4);
        V2TIMManager.getInstance().addSimpleMsgListener(this.mSimpleMsgListener);
        V2TIMManager.getInstance().addIMSDKListener(this.mTIMSDKListener);
        return V2TIMManager.getInstance().initSDK(context, sdkAppId, this.mSDKConfig);
    }

    private void joinGroup() {
        for (Map.Entry<String, String> entry : this.mConfig.group_list.entrySet()) {
            this.mJoinGroupCount = this.mConfig.group_list.size();
            final String group_id = entry.getKey();
            String group_type = entry.getValue();
            V2TIMManager.getInstance().joinGroup(group_id, group_type, new V2TIMCallback(){

                public void onSuccess() {
                    Log.i((String)"imsdk", (String)("joinGroup success " + group_id));
                    Handler delivery = new Handler(Looper.getMainLooper());
                    delivery.post(new Runnable(){

                        @Override
                        public void run() {
                            ChatServerV2.this.mIsGroupJoined = true;
                            ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_CONNECTED;
                            if (ChatServerV2.this.mCallback != null) {
                                ChatServerV2.this.mJoinGroupCount = ChatServerV2.this.mJoinGroupCount - 1;
                                if (ChatServerV2.this.mJoinGroupCount == 0) {
                                    ChatServerV2.this.mCallback.onGroupState(ConnectServerV2.JoinState.STATE_JOIN_GROUP_SUCCESS, group_id, 0, "join group succeed");
                                }
                            }
                        }
                    });
                }

                public void onError(final int code, final String desc) {
                    Log.i((String)"imsdk", (String)("joinGroup onError " + code + desc));
                    Handler delivery = new Handler(Looper.getMainLooper());
                    delivery.post(new Runnable(){

                        @Override
                        public void run() {
                            if (code == 10013) {
                                ChatServerV2.this.mIsGroupJoined = true;
                                ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_CONNECTED;
                                ChatServerV2.this.mJoinGroupCount = ChatServerV2.this.mJoinGroupCount - 1;
                                if (ChatServerV2.this.mJoinGroupCount == 0) {
                                    ChatServerV2.this.mCallback.onGroupState(ConnectServerV2.JoinState.STATE_JOIN_GROUP_SUCCESS, group_id, 0, "join group succeed");
                                }
                            } else {
                                ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
                                if (ChatServerV2.this.mCallback != null) {
                                    ChatServerV2.this.mCallback.onGroupState(ConnectServerV2.JoinState.STATE_JOIN_GROUP_FAILED, group_id, code, desc);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public void setEventCallback(ConnectServerV2.EventCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void connect(VHChatServerV2Def.ConnectConfigInfo config) {
        this.mConfig = config;
        this.mState = ConnectServerV2.NetState.STATE_CONNECTING;
        if (this.init(config.context, Integer.parseInt(String.valueOf(config.sdk_app_id)))) {
            int loginStatus = V2TIMManager.getInstance().getLoginStatus();
            Log.i((String)"imsdk", (String)(" loginStatus " + loginStatus));
            if (loginStatus == 3) {
                V2TIMManager.getInstance().login(config.user_id, config.user_sig, new V2TIMCallback(){

                    public void onSuccess() {
                        Log.i((String)"imsdk", (String)"login success");
                        Handler delivery = new Handler(Looper.getMainLooper());
                        delivery.post(new Runnable(){

                            @Override
                            public void run() {
                                ChatServerV2.this.joinGroup();
                            }
                        });
                    }

                    public void onError(final int code, final String desc) {
                        Log.i((String)"imsdk", (String)("failure, code:" + code + ", desc:" + desc));
                        Handler delivery = new Handler(Looper.getMainLooper());
                        delivery.post(new Runnable(){

                            @Override
                            public void run() {
                                if (ChatServerV2.this.mCallback != null) {
                                    ChatServerV2.this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
                                    ChatServerV2.this.mCallback.onLoginState(ConnectServerV2.JoinState.STATE_LOGIN_FAILED, code, desc);
                                }
                            }
                        });
                    }
                });
            } else if (loginStatus == 1) {
                this.joinGroup();
            }
        } else {
            this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
            if (this.mCallback != null) {
                this.mCallback.onInit("init error");
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.mTIMSDKListener != null) {
            V2TIMManager.getInstance().removeIMSDKListener(this.mTIMSDKListener);
        }
        if (this.mSimpleMsgListener != null) {
            V2TIMManager.getInstance().removeSimpleMsgListener(this.mSimpleMsgListener);
        }
        this.mIsGroupJoined = false;
        this.mState = ConnectServerV2.NetState.STATE_DISCONNECT;
        V2TIMManager.getInstance().logout(new V2TIMCallback(){

            public void onSuccess() {
                Log.i((String)"imsdk", (String)"logout onSuccess");
            }

            public void onError(int code, String desc) {
                Log.i((String)"imsdk", (String)"logout onError");
            }
        });
    }

    @Override
    public void destory() {
        V2TIMManager.getInstance().unInitSDK();
    }

    @Override
    public ConnectServerV2.NetState getState() {
        return this.mState;
    }
}

