/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautify;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.beautify.EmptyVHBeautifyService;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.IVHBeautifyService;
import com.vhall.beautify.IVHFaceDetectionListener;
import com.vhall.beautify.util.VHStackUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class VHBeautifyKit {
    private static final String TAG = "VHBeautifyKit";
    private static VHBeautifyKit mInstance;
    private Application mApplication;
    private static final String BEAUTIFY_IMPL = "beautify_impl";
    private IVHBeautifyService mSingleBeautifyService;
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private volatile boolean mBeautifyEnable = false;
    private volatile boolean mFaceDetectionEnable = false;
    private JSONObject mEnableConfig;
    private int mWindowOrientation = 1;
    private IVHFaceDetectionListener mFaceDetectionListener = null;
    private final String BEAUTY_CONFIG_OFF = "beauty config is off";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VHBeautifyKit getInstance() {
        if (null != mInstance) return mInstance;
        Class<VHBeautifyKit> clazz = VHBeautifyKit.class;
        synchronized (VHBeautifyKit.class) {
            if (null != mInstance) return mInstance;
            mInstance = new VHBeautifyKit();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private VHBeautifyKit() {
    }

    public void init(Application application, IVHBeautifyInitListener listener) {
        this.mApplication = application;
        this.filterBeautifyImpl();
        if (!this.isVHConfigEnable()) {
            listener.onError(302, "beauty config is off");
            return;
        }
        this.mExecutorService.execute(() -> this.doRegister(listener));
    }

    public void setEnableConfig(JSONObject config) {
        if (!VHStackUtil.configLegal()) {
            throw new IllegalAccessError("do not call this method!");
        }
        this.mEnableConfig = config;
    }

    public boolean isVHallBeautify() {
        return null == this.mSingleBeautifyService || this.mSingleBeautifyService instanceof EmptyVHBeautifyService;
    }

    private IVHBeautifyService beautifyService() {
        return this.beautifyService(false);
    }

    private IVHBeautifyService beautifyService(boolean auth) {
        if (auth && !this.isVHConfigEnable()) {
            return new EmptyVHBeautifyService();
        }
        if (null == this.mSingleBeautifyService) {
            this.mSingleBeautifyService = new EmptyVHBeautifyService();
        }
        return this.mSingleBeautifyService;
    }

    public void setFaceDetectionListener(IVHFaceDetectionListener faceDetectionListener) {
        this.mFaceDetectionListener = faceDetectionListener;
    }

    public IVHFaceDetectionListener getFaceDetectionListener() {
        return this.mFaceDetectionListener;
    }

    public void setFaceDetectionEnable(boolean enable) {
        this.mFaceDetectionEnable = enable;
    }

    public boolean setBeautifyEnable(boolean enable) {
        this.mBeautifyEnable = enable;
        if (this.isVHConfigEnable()) {
            if (null != this.mSingleBeautifyService) {
                this.mSingleBeautifyService.onBeautifyEnable(enable);
            }
            return true;
        }
        Log.e((String)TAG, (String)"beauty config is off");
        return false;
    }

    public void setActivityOrientation(int orientation) {
        if (orientation != 0) {
            orientation = 1;
        }
        this.mWindowOrientation = orientation;
        if (null != this.mSingleBeautifyService) {
            this.mSingleBeautifyService.setActivityOrientation(orientation);
        }
    }

    public boolean isBeautifyAuthEnable() {
        return this.isVHConfigEnable();
    }

    public boolean isBeautifyEnable() {
        return this.isVHConfigEnable() && this.mBeautifyEnable;
    }

    public boolean isFaceDetectionEnable() {
        return this.mFaceDetectionEnable;
    }

    public int renderWithTexture(int width, int height, int texture) {
        return this.beautifyService().renderWithTexture(width, height, texture);
    }

    public void setRenderOfRTC(boolean isRTC) {
        this.beautifyService().setRenderOfRTC(isRTC);
    }

    public String sdkModel() {
        return this.beautifyService().sdkModel();
    }

    public void try2Restore() {
        this.beautifyService().try2Restore();
    }

    public void onCameraSwitch(int cameraFacing) {
        this.beautifyService().onCameraSwitch(cameraFacing);
    }

    public void loadFaceProcessor() {
        this.beautifyService().loadFaceProcessor();
    }

    public void judgeDeviceLevel(WeakReference<Context> activityWeakReference) {
        this.beautifyService().judgeDeviceLevel(activityWeakReference);
    }

    public void setFilterIntensity(double filterIntensity) {
        this.beautifyService(true).setFilterIntensity(filterIntensity);
    }

    public void setFilter(String filterName, double filterIntensity) {
        this.beautifyService(true).setFilter(filterName, filterIntensity);
    }

    public void updateParamIntensity(String key, double value) {
        this.beautifyService(true).updateParamIntensity(key, value);
    }

    public double getParamIntensity(String key) {
        return this.beautifyService().getParamIntensity(key);
    }

    public void release() {
        this.beautifyService().release();
    }

    private void doRegister(IVHBeautifyInitListener listener) {
        this.beautifyService().init(this.mApplication.getApplicationContext(), listener);
    }

    private boolean isVHConfigEnable() {
        return null != this.mEnableConfig && this.mEnableConfig.optBoolean("enable");
    }

    private void filterBeautifyImpl() {
        try {
            ApplicationInfo info = this.mApplication.getPackageManager().getPackageInfo((String)this.mApplication.getPackageName(), (int)128).applicationInfo;
            Bundle metaData = info.metaData;
            for (String component : metaData.keySet()) {
                if (!TextUtils.equals((CharSequence)metaData.getString(component), (CharSequence)BEAUTIFY_IMPL)) continue;
                this.mSingleBeautifyService = (IVHBeautifyService)Class.forName(component).newInstance();
                this.reConfigWindowOrientation();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reConfigWindowOrientation() {
        this.setActivityOrientation(this.mWindowOrientation);
    }
}

