/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautify;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FuDeviceUtils {
    public static final String TAG = "FuDeviceUtils";
    public static final int DEVICE_LEVEL_HIGH = 2;
    public static final int DEVICE_LEVEL_MID = 1;
    public static final int DEVICE_LEVEL_LOW = 0;
    public static final int DEVICEINFO_UNKNOWN = -1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    public static final String[] upscaleDevice = new String[]{"vivo X6S A", "MHA-AL00", "VKY-AL00", "V1838A"};
    public static final String[] lowDevice = new String[0];
    public static final String[] middleDevice = new String[]{"OPPO R11s", "PAR-AL00", "MI 8 Lite", "ONEPLUS A6000", "PRO 6", "PRO 7 Plus"};
    public static final String Nexus_6P = "Nexus 6P";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static long getTotalMemory(Context c) {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            if (memInfo != null) {
                return memInfo.totalMem;
            }
            return -1L;
        }
        long totalMem = -1L;
        try (FileInputStream stream = new FileInputStream("/proc/meminfo");){
            totalMem = FuDeviceUtils.parseFileForValue("MemTotal", stream);
            totalMem *= 1024L;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return totalMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUMaxFreqKHz() {
        int maxFreq;
        block13: {
            maxFreq = -1;
            try {
                for (int i = 0; i < FuDeviceUtils.getNumberOfCPUCores(); ++i) {
                    String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoMaxFreqFile = new File(filename);
                    if (!cpuInfoMaxFreqFile.exists() || !cpuInfoMaxFreqFile.canRead()) continue;
                    byte[] buffer = new byte[128];
                    try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                }
                if (maxFreq != -1) break block13;
                try (FileInputStream stream = new FileInputStream("/proc/cpuinfo");){
                    int freqBound = FuDeviceUtils.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1024) > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
            }
            catch (IOException e) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = FuDeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = FuDeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
            }
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            buf.close();
            int n = FuDeviceUtils.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        return Integer.valueOf(str.substring(2)) + 1;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int textIndex;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return FuDeviceUtils.extractValue(buffer, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi.availMem;
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getHardWare() {
        try {
            String text;
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String last = "";
            while ((text = br.readLine()) != null) {
                last = text;
            }
            if (last.contains("Hardware")) {
                String[] hardWare = last.split(":\\s+", 2);
                return hardWare[1];
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Build.HARDWARE;
    }

    public static int judgeDeviceLevel(Context context) {
        int specialDevice = FuDeviceUtils.judgeDeviceLevelInDeviceName();
        if (specialDevice >= 0) {
            return specialDevice;
        }
        int ramLevel = FuDeviceUtils.judgeMemory(context);
        int cpuLevel = FuDeviceUtils.judgeCPU();
        int level = ramLevel == 0 || ramLevel == 1 || cpuLevel == 0 ? 0 : (cpuLevel > 1 ? 2 : 1);
        Log.d((String)TAG, (String)("DeviceLevel: " + level));
        return level;
    }

    private static int judgeDeviceLevelInDeviceName() {
        String currentDeviceName = FuDeviceUtils.getDeviceName();
        for (String deviceName : upscaleDevice) {
            if (!deviceName.equals(currentDeviceName)) continue;
            return 2;
        }
        for (String deviceName : middleDevice) {
            if (!deviceName.equals(currentDeviceName)) continue;
            return 1;
        }
        for (String deviceName : lowDevice) {
            if (!deviceName.equals(currentDeviceName)) continue;
            return 0;
        }
        return -1;
    }

    private static int judgeMemory(Context context) {
        long ramMB = FuDeviceUtils.getTotalMemory(context) / 0x100000L;
        int level = -1;
        level = ramMB <= 2000L ? 0 : (ramMB <= 3000L ? 1 : (ramMB <= 4000L ? 2 : (ramMB <= 6000L ? 3 : 4)));
        return level;
    }

    private static int judgeCPU() {
        int level = 0;
        String cpuName = FuDeviceUtils.getHardWare();
        int freqMHz = FuDeviceUtils.getCPUMaxFreqKHz() / 1024;
        if (!TextUtils.isEmpty((CharSequence)cpuName)) {
            if (cpuName.contains("qcom") || cpuName.contains("Qualcomm")) {
                return FuDeviceUtils.judgeQualcommCPU(cpuName, freqMHz);
            }
            if (cpuName.contains("hi") || cpuName.contains("kirin")) {
                return FuDeviceUtils.judgeSkinCPU(cpuName, freqMHz);
            }
            if (cpuName.contains("MT")) {
                return FuDeviceUtils.judgeMTCPU(cpuName, freqMHz);
            }
        }
        level = freqMHz <= 1600 ? 0 : (freqMHz <= 1950 ? 1 : (freqMHz <= 2500 ? 2 : 3));
        return level;
    }

    private static int judgeMTCPU(String cpuName, int freqMHz) {
        int level = 0;
        int mtCPUVersion = FuDeviceUtils.getMTCPUVersion(cpuName);
        level = mtCPUVersion == -1 ? (freqMHz <= 1600 ? 0 : (freqMHz <= 2200 ? 1 : (freqMHz <= 2700 ? 2 : 3))) : (mtCPUVersion < 6771 ? (freqMHz <= 1600 ? 0 : 1) : (freqMHz <= 1600 ? 0 : (freqMHz <= 1900 ? 1 : (freqMHz <= 2500 ? 2 : 3))));
        return level;
    }

    private static int getMTCPUVersion(String cpuName) {
        int cpuVersion = -1;
        if (cpuName.length() > 5) {
            String cpuVersionStr = cpuName.substring(2, 6);
            try {
                cpuVersion = Integer.valueOf(cpuVersionStr);
            }
            catch (NumberFormatException exception) {
                exception.printStackTrace();
            }
        }
        return cpuVersion;
    }

    private static int judgeQualcommCPU(String cpuName, int freqMHz) {
        int level = 0;
        level = cpuName.contains("MSM") ? (freqMHz <= 1600 ? 0 : 1) : (freqMHz <= 1600 ? 0 : (freqMHz <= 2000 ? 1 : (freqMHz <= 2500 ? 2 : 3)));
        return level;
    }

    private static int judgeSkinCPU(String cpuName, int freqMHz) {
        int level = 0;
        if (cpuName.startsWith("hi")) {
            if (freqMHz <= 1600) {
                level = 0;
            } else if (freqMHz <= 2000) {
                level = 1;
            }
        } else {
            level = freqMHz <= 1600 ? 0 : (freqMHz <= 2000 ? 1 : (freqMHz <= 2500 ? 2 : 3));
        }
        return level;
    }

    public static boolean isNexus6P() {
        return FuDeviceUtils.getDeviceName().equalsIgnoreCase(Nexus_6P);
    }

    public static String getDeviceName() {
        String deviceName = "";
        if (Build.MODEL != null) {
            deviceName = Build.MODEL;
        }
        return deviceName;
    }
}

