/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.dash.manifest;

import com.vhall.android.exoplayer2.source.dash.manifest.RangedUri;
import com.vhall.android.exoplayer2.source.dash.manifest.Representation;
import com.vhall.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.vhall.android.exoplayer2.util.Util;
import java.util.List;

public abstract class SegmentBase {
    final RangedUri initialization;
    final long timescale;
    final long presentationTimeOffset;

    public SegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset) {
        this.initialization = initialization;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
    }

    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public long getPresentationTimeOffsetUs() {
        return Util.scaleLargeTimestamp((long)this.presentationTimeOffset, (long)1000000L, (long)this.timescale);
    }

    public static class SegmentTimelineElement {
        final long startTime;
        final long duration;

        public SegmentTimelineElement(long startTime, long duration) {
            this.startTime = startTime;
            this.duration = duration;
        }
    }

    public static class SegmentTemplate
    extends MultiSegmentBase {
        final UrlTemplate initializationTemplate;
        final UrlTemplate mediaTemplate;

        public SegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline);
            this.initializationTemplate = initializationTemplate;
            this.mediaTemplate = mediaTemplate;
        }

        @Override
        public RangedUri getInitialization(Representation representation) {
            if (this.initializationTemplate != null) {
                String urlString = this.initializationTemplate.buildUri(representation.format.id, 0L, representation.format.bitrate, 0L);
                return new RangedUri(urlString, 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long sequenceNumber) {
            long time = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber)))).startTime : (sequenceNumber - this.startNumber) * this.duration;
            String uriString = this.mediaTemplate.buildUri(representation.format.id, sequenceNumber, representation.format.bitrate, time);
            return new RangedUri(uriString, 0L, -1L);
        }

        @Override
        public int getSegmentCount(long periodDurationUs) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size();
            }
            if (periodDurationUs != -9223372036854775807L) {
                long durationUs = this.duration * 1000000L / this.timescale;
                return (int)Util.ceilDivide((long)periodDurationUs, (long)durationUs);
            }
            return -1;
        }
    }

    public static class SegmentList
    extends MultiSegmentBase {
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, List<RangedUri> mediaSegments) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline);
            this.mediaSegments = mediaSegments;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long sequenceNumber) {
            return this.mediaSegments.get((int)(sequenceNumber - this.startNumber));
        }

        @Override
        public int getSegmentCount(long periodDurationUs) {
            return this.mediaSegments.size();
        }

        @Override
        public boolean isExplicit() {
            return true;
        }
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final long startNumber;
        final long duration;
        final List<SegmentTimelineElement> segmentTimeline;

        public MultiSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, List<SegmentTimelineElement> segmentTimeline) {
            super(initialization, timescale, presentationTimeOffset);
            this.startNumber = startNumber;
            this.duration = duration;
            this.segmentTimeline = segmentTimeline;
        }

        public long getSegmentNum(long timeUs, long periodDurationUs) {
            long firstSegmentNum = this.getFirstSegmentNum();
            long segmentCount = this.getSegmentCount(periodDurationUs);
            if (segmentCount == 0L) {
                return firstSegmentNum;
            }
            if (this.segmentTimeline == null) {
                long durationUs = this.duration * 1000000L / this.timescale;
                long segmentNum = this.startNumber + timeUs / durationUs;
                return segmentNum < firstSegmentNum ? firstSegmentNum : (segmentCount == -1L ? segmentNum : Math.min(segmentNum, firstSegmentNum + segmentCount - 1L));
            }
            long lowIndex = firstSegmentNum;
            long highIndex = firstSegmentNum + segmentCount - 1L;
            while (lowIndex <= highIndex) {
                long midIndex = lowIndex + (highIndex - lowIndex) / 2L;
                long midTimeUs = this.getSegmentTimeUs(midIndex);
                if (midTimeUs < timeUs) {
                    lowIndex = midIndex + 1L;
                    continue;
                }
                if (midTimeUs > timeUs) {
                    highIndex = midIndex - 1L;
                    continue;
                }
                return midIndex;
            }
            return lowIndex == firstSegmentNum ? lowIndex : highIndex;
        }

        public final long getSegmentDurationUs(long sequenceNumber, long periodDurationUs) {
            if (this.segmentTimeline != null) {
                long duration = this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber))).duration;
                return duration * 1000000L / this.timescale;
            }
            int segmentCount = this.getSegmentCount(periodDurationUs);
            return segmentCount != -1 && sequenceNumber == this.getFirstSegmentNum() + (long)segmentCount - 1L ? periodDurationUs - this.getSegmentTimeUs(sequenceNumber) : this.duration * 1000000L / this.timescale;
        }

        public final long getSegmentTimeUs(long sequenceNumber) {
            long unscaledSegmentTime = this.segmentTimeline != null ? this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber))).startTime - this.presentationTimeOffset : (sequenceNumber - this.startNumber) * this.duration;
            return Util.scaleLargeTimestamp((long)unscaledSegmentTime, (long)1000000L, (long)this.timescale);
        }

        public abstract RangedUri getSegmentUrl(Representation var1, long var2);

        public long getFirstSegmentNum() {
            return this.startNumber;
        }

        public abstract int getSegmentCount(long var1);

        public boolean isExplicit() {
            return this.segmentTimeline != null;
        }
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        final long indexStart;
        final long indexLength;

        public SingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, long indexStart, long indexLength) {
            super(initialization, timescale, presentationTimeOffset);
            this.indexStart = indexStart;
            this.indexLength = indexLength;
        }

        public SingleSegmentBase() {
            this(null, 1L, 0L, 0L, 0L);
        }

        public RangedUri getIndex() {
            return this.indexLength <= 0L ? null : new RangedUri(null, this.indexStart, this.indexLength);
        }
    }
}

