/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.BatteryManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.vhall.crash.utils.InternalUtils;
import com.vhall.crash.utils.NetState;
import org.json.JSONException;
import org.json.JSONObject;

public class VHDeviceUtils {
    private static JSONObject sDeviceMessages = new JSONObject();

    public static JSONObject getDeviceInfo(Application application) {
        try {
            VHDeviceUtils.injectBaseParams(application);
            VHDeviceUtils.injectScreenParams(application);
            VHDeviceUtils.injectApkParams(application);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sDeviceMessages;
    }

    private static void injectApkParams(Application application) {
        try {
            PackageInfo packageInfo = VHDeviceUtils.getPackageInfo((Context)application);
            if (packageInfo != null) {
                sDeviceMessages.put("verCode", packageInfo.versionCode);
                sDeviceMessages.put("version", (Object)packageInfo.versionName);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void injectBaseParams(Application application) {
        try {
            sDeviceMessages.put("pkgName", (Object)application.getPackageName());
            sDeviceMessages.put("appName", (Object)VHDeviceUtils.getAppName((Context)application));
            sDeviceMessages.put("crashVersion", (Object)"1.5.0");
            sDeviceMessages.put("model", (Object)Build.MODEL);
            sDeviceMessages.put("product", (Object)Build.PRODUCT);
            sDeviceMessages.put("vendor", (Object)Build.MANUFACTURER);
            sDeviceMessages.put("sdk_api", Build.VERSION.SDK_INT);
            sDeviceMessages.put("cpu", (Object)Build.CPU_ABI);
            sDeviceMessages.put("hasConnected", NetState.hasNetWorkConnection((Context)application));
            sDeviceMessages.put("netType", NetState.getNetWorkClass((Context)application));
            sDeviceMessages.put("currentTime", (Object)InternalUtils.getCurrentDate());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void injectScreenParams(Application application) {
        try {
            WindowManager wm = (WindowManager)application.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            sDeviceMessages.put("widthPixels", dm.widthPixels);
            sDeviceMessages.put("heightPixels", dm.heightPixels);
            sDeviceMessages.put("density", dm.densityDpi);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static PackageInfo getPackageInfo(Context application) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = application.getPackageManager().getPackageInfo(application.getPackageName(), 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return packageInfo;
    }

    public static String getVerName(Context context) {
        try {
            return VHDeviceUtils.getPackageInfo((Context)context).versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-1.0";
        }
    }

    public static String getAppName(Context application) {
        try {
            return application.getApplicationInfo().loadLabel(application.getPackageManager()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "UNKONWN";
        }
    }

    public static String getBatterySimpInfo(Context context) {
        if (null != context && Build.VERSION.SDK_INT >= 21) {
            String info = null;
            try {
                BatteryManager mBatteryManager = (BatteryManager)context.getSystemService("batterymanager");
                info = "battery_cur  :" + mBatteryManager.getIntProperty(4);
                if (Build.VERSION.SDK_INT >= 26) {
                    info = info + "\nbattery_chr  :" + VHDeviceUtils.parseChargingType(mBatteryManager.getIntProperty(6)) + "\n";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return info;
        }
        return "NONE";
    }

    private static String parseChargingType(int type) {
        String charing;
        switch (type) {
            case 2: {
                charing = "\u6b63\u5728\u5145\u7535";
                break;
            }
            case 3: 
            case 4: {
                charing = "\u672a\u5145\u7535";
                break;
            }
            case 5: {
                charing = "\u5df2\u5145\u6ee1";
                break;
            }
            default: {
                charing = "UNKNOWN";
            }
        }
        return charing;
    }
}

