/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import com.vhall.httpclient.utils.OKHttpUtils;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class UploadUtil {
    private OkHttpClient okHttpClient = new OkHttpClient();

    private UploadUtil() {
    }

    public static UploadUtil getInstance() {
        return UploadUtilInstance.INSTANCE;
    }

    public ResponseBody upload(String url, File file) throws IOException {
        OkHttpClient client = OKHttpUtils.createOkClient();
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), fileBody).build();
        Request request = new Request.Builder().header("Authorization", "ClientID" + UUID.randomUUID()).url(url).post((RequestBody)requestBody).build();
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        return response.body();
    }

    private static class UploadUtilInstance {
        private static final UploadUtil INSTANCE = new UploadUtil();

        private UploadUtilInstance() {
        }
    }
}

