/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class NetState {
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_CLASS_2_G = 2;
    public static final int NETWORK_CLASS_3_G = 3;
    public static final int NETWORK_CLASS_4_G = 4;

    public static boolean hasNetWorkConnection(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    public static int getNetWorkClass(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        try {
            switch (telephonyManager.getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return 2;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return 3;
                }
                case 13: {
                    return 4;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getNetWorkStatus(Context context) {
        int netWorkType = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            int type = networkInfo.getType();
            if (type == 1) {
                netWorkType = 1;
            } else if (type == 0) {
                netWorkType = NetState.getNetWorkClass(context);
            }
        }
        return netWorkType;
    }
}

