/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.vhall.crash.ICrashConfig;
import com.vhall.crash.utils.CrashAnalyzer;
import com.vhall.crash.utils.CrashUtils;
import com.vhall.crash.utils.EXCrashInfo;
import com.vhall.crash.utils.InternalUtils;
import com.vhall.crash.utils.MemoryUtil;
import com.vhall.crash.utils.ReinforcementUtil;
import com.vhall.crash.utils.StatAnalyzer;
import com.vhall.crash.utils.UploadUtil;
import com.vhall.crash.utils.VHDeviceUtils;
import com.vhall.crash.utils.VHFileUtils;
import com.vhall.crash.utils.VLog;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;

public class VHCrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = VHCrashHandler.class.getSimpleName();
    private static final String MSGOFUNINITED = "are you invoked init method?";
    private Application mInstance;
    private ICrashConfig mConfig;
    private WorkHandler mHandler;
    public boolean debug;
    public static String mCrashRootDir;
    private Thread.UncaughtExceptionHandler mSystemHandler;
    private static final int INIT_WORK_WHAT = 1;
    private static final int SCAN_EXIT_FILE_WHAT = 2;
    private static final int THRESHOLD = 10;
    private static final long CHECK_DELAY = 5000L;
    private int uploadCrashCount = 0;
    private static String roomId;
    private static volatile VHCrashHandler sCrashHandler;

    private VHCrashHandler(ICrashConfig config, Application application) {
        this.mInstance = application;
        this.mConfig = config;
        this.init();
        if (this.mConfig.uploadToStatistic()) {
            this.sendLaunchEvent((Context)this.mInstance);
        }
    }

    private void sendLaunchEvent(Context context) {
        StatAnalyzer.putLaunchEvent(context);
    }

    void setSystemHandler(Thread.UncaughtExceptionHandler systemHandler) {
        this.mSystemHandler = systemHandler;
    }

    private void init() {
        HandlerThread handlerThread = new HandlerThread(this.getClass().getName());
        handlerThread.start();
        this.mHandler = new WorkHandler(handlerThread.getLooper());
        this.mHandler.obtainMessage(1).sendToTarget();
        this.mHandler.removeMessages(2);
        this.mHandler.sendEmptyMessageDelayed(2, 10000L);
        this.debug = this.mConfig.isDebug();
        mCrashRootDir = this.mConfig.getCrashRootDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(ICrashConfig config, Application application) {
        if (sCrashHandler != null) return;
        Class<VHCrashHandler> clazz = VHCrashHandler.class;
        synchronized (VHCrashHandler.class) {
            if (sCrashHandler != null) return;
            sCrashHandler = new VHCrashHandler(config, application);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static VHCrashHandler share() {
        return sCrashHandler;
    }

    public static VHCrashHandler setRoomId(String roomId) {
        if (sCrashHandler == null) {
            VLog.e(MSGOFUNINITED);
        }
        VHCrashHandler.roomId = roomId;
        return sCrashHandler;
    }

    public static String getRoomId() {
        return roomId;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.uploadCrashCount < this.mConfig.getUploadLimit()) {
            block4: {
                try {
                    this.handleCrash(t, e);
                }
                catch (IllegalAccessException ex) {
                    if (CrashAnalyzer.isThresholdEx(ex.getMessage())) break block4;
                    ex.printStackTrace();
                }
            }
            if (this.mSystemHandler != null) {
                this.mSystemHandler.uncaughtException(t, e);
            }
        }
    }

    void handleCrash(Thread t, Throwable e) throws IllegalAccessException {
        boolean isVhallCrash;
        Map<String, String> crashStackTraceMap;
        if (this.mConfig.getCallBack() != null) {
            this.mConfig.getCallBack().onCrash(t, e);
        }
        String crashStackTrace = (crashStackTraceMap = CrashUtils.dumpCrashInfo(e)).containsKey("k_crash") ? crashStackTraceMap.get("k_crash") : null;
        String crashTag = crashStackTraceMap.containsKey("k_tag") ? crashStackTraceMap.get("k_tag") : null;
        boolean bl = isVhallCrash = null == crashTag;
        if (null == crashStackTrace) {
            return;
        }
        CrashAnalyzer.analyse((Context)this.mInstance, this.mConfig.fingerprintThreshold(), CrashUtils.dumpCrashMessage(e));
        StringBuilder appCrashInfo = new StringBuilder();
        appCrashInfo.append("-----------------------------------------------start-------------------------------------------------\n");
        this.appendDeviceInfo(appCrashInfo);
        this.appendProcessInfo(appCrashInfo, t);
        this.appendRuntimeInfo(appCrashInfo);
        this.appendExtraInfos(appCrashInfo);
        this.appendCrashInfo(appCrashInfo, crashStackTrace);
        appCrashInfo.append("-----------------------------------------------end-------------------------------------------------");
        String fileName = null;
        if (!this.mConfig.filterNonVhallOfCollection() || this.mConfig.filterNonVhallOfCollection() && isVhallCrash) {
            fileName = VHFileUtils.writeFileToStorage((Context)this.mInstance, appCrashInfo.toString());
        }
        if (this.mConfig.uploadToStatistic() && (!this.mConfig.filterNonVhallOfStat() || this.mConfig.filterNonVhallOfStat() && isVhallCrash)) {
            EXCrashInfo crashInfo = new EXCrashInfo(CrashUtils.dumpCrashCause(e), CrashUtils.dumpCrashMessage(e), fileName);
            StatAnalyzer.putCrashEvent((Context)this.mInstance, crashInfo.toJsonString());
        }
        VLog.e(String.format("thread %s   throwable  %s", t.getName(), appCrashInfo.toString()));
        this.immediatelyUploadImpl();
    }

    private void immediatelyUploadImpl() {
        if (this.mConfig.isImmediatelyUpload()) {
            this.mHandler.sendEmptyMessage(2);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void appendProcessInfo(StringBuilder appCrashInfo, Thread crashThread) {
        appCrashInfo.append("[Process/Thread info]\n");
        if (null != this.mInstance) {
            appCrashInfo.append("pro_nam:").append(InternalUtils.getCurrentProcessName((Context)this.mInstance));
        }
        appCrashInfo.append("\npro_pid:").append(Process.myPid());
        appCrashInfo.append("\nnat_tid:").append(Process.myTid());
        if (null != crashThread) {
            appCrashInfo.append("\njvm_tna:").append(crashThread.getName());
            appCrashInfo.append("\njvm_tid:").append(crashThread.getId());
        } else {
            appCrashInfo.append("\ncrashed thread is null, using currentThread api.");
            appCrashInfo.append("\njvm_tna:").append(Thread.currentThread().getName());
            appCrashInfo.append("\njvm_tid:").append(Thread.currentThread().getId());
        }
        appCrashInfo.append("\n");
    }

    private void appendRuntimeInfo(StringBuilder appCrashInfo) {
        appCrashInfo.append("[Runtime info]\n");
        appCrashInfo.append("reinforcement:").append(ReinforcementUtil.checkRFType());
        appCrashInfo.append("\nmem_total    :").append(MemoryUtil.getTotalMemory());
        appCrashInfo.append("\nmem_available:").append(MemoryUtil.getAiailableMemory());
        appCrashInfo.append("\n").append(VHDeviceUtils.getBatterySimpInfo((Context)this.mInstance));
        appCrashInfo.append("\n");
    }

    private void appendExtraInfos(StringBuilder appCrashInfo) {
        appCrashInfo.append("[Extras info]\n");
        appCrashInfo.append(this.mConfig.getExtraInfos());
        appCrashInfo.append("\n");
    }

    private void appendCrashInfo(StringBuilder appCrashInfoBuilder, String crashInfo) {
        appCrashInfoBuilder.append("[Crash info]\n");
        appCrashInfoBuilder.append(crashInfo);
        appCrashInfoBuilder.append("\n");
    }

    private void appendDeviceInfo(StringBuilder appCrashInfo) {
        appCrashInfo.append("[Device info]\n");
        appCrashInfo.append(VHDeviceUtils.getDeviceInfo(this.mInstance));
        appCrashInfo.append("\n");
    }

    private synchronized void scanCrashFiles() {
        int count = 0;
        try {
            File dirFile = new File(VHFileUtils.getInternalCrashPath((Context)this.mInstance)).getParentFile();
            File[] files = dirFile.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (count >= 2) {
                        f.delete();
                        continue;
                    }
                    StringBuilder builder = this.createParams(f);
                    boolean result = this.upFileToServer(String.format("%s?%s", this.mConfig.getUploadUrl(), builder), f);
                    ++this.uploadCrashCount;
                    if (result) {
                        f.delete();
                        VLog.e(String.format("%s,%s", f.getAbsolutePath(), "crash log uploaded and delete"));
                        ++count;
                        continue;
                    }
                    VLog.e(String.format("%s,%s", f.getAbsolutePath(), "crash log upload fail"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean upFileToServer(String url, File file) {
        try {
            ResponseBody responseBody = UploadUtil.getInstance().upload(url, file);
            String result = responseBody.string();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void uploadStatToServer() {
        if (null != this.mInstance && null != this.mConfig) {
            StatAnalyzer.doReport((Context)this.mInstance, this.mConfig.getStatUploadUrl());
        }
    }

    private StringBuilder createParams(File f) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamID", "edu_65d66e32");
        params.put("version", VHDeviceUtils.getVerName((Context)this.mInstance));
        params.put("filename", f.getName());
        params.put("crashTime", f.lastModified() + "");
        params.put("MengZhu", "0");
        params.put("token", "3160679032");
        StringBuilder builder = new StringBuilder();
        for (String k : params.keySet()) {
            builder.append(String.format("%s=%s", k, params.get(k)));
            builder.append("&");
        }
        builder.subSequence(0, builder.length() - 1);
        return builder;
    }

    static {
        roomId = "";
    }

    class WorkHandler
    extends Handler {
        private int count;

        public WorkHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    this.sendEmptyMessageDelayed(1, 5000L);
                    this.injectHandlerToSystem();
                    break;
                }
                case 2: {
                    VHCrashHandler.this.scanCrashFiles();
                    VHCrashHandler.this.uploadStatToServer();
                }
            }
        }

        void injectHandlerToSystem() {
            if (this.isInject()) {
                VLog.d("do nothing");
            } else {
                this.injectHandlerImpl();
                VLog.e("inject handler to system!");
            }
        }

        void injectHandlerImpl() {
            Thread.UncaughtExceptionHandler systemHandler = Thread.getDefaultUncaughtExceptionHandler();
            VHCrashHandler.this.setSystemHandler(systemHandler);
            Thread.setDefaultUncaughtExceptionHandler(VHCrashHandler.this);
        }

        boolean isInject() {
            if (++this.count > 10) {
                this.removeMessages(1);
            }
            return Thread.getDefaultUncaughtExceptionHandler() == VHCrashHandler.this;
        }
    }
}

