/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash;

import com.vhall.crash.VHCrashHandler;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public interface ICrashConfig {
    public String getUploadUrl();

    public String getStatUploadUrl();

    public boolean isDebug();

    public String getCrashRootDir();

    public Map<String, String> getExtraFields();

    public String getExtraInfos();

    public CrashCallBack getCallBack();

    public boolean isImmediatelyUpload();

    public int getUploadLimit();

    public int fingerprintThreshold();

    public boolean uploadToStatistic();

    public boolean filterNonVhallOfStat();

    public boolean filterNonVhallOfCollection();

    public static interface CrashCallBack {
        public void onCrash(Thread var1, Throwable var2);
    }

    public static class Builder {
        private static final String DEV_URL = "https://crash-dev-log.vhall.com:6587/upload";
        private static final String RELEASE_URL = "https://crash-prod-log.vhall.com/upload";
        private static final String DEV_URL_STAT = "https://t-dc.e.vhall.com/prostat";
        private static final String RELEASE_URL_STAT = "https://dc.e.vhall.com/prostat";
        private boolean debug;
        private String crashRootDir = "vhall";
        private String uploadUrl = "https://crash-dev-log.vhall.com:6587/upload";
        private String uploadUrlStat = "https://t-dc.e.vhall.com/prostat";
        private Map<String, String> extraFields = new HashMap<String, String>();
        private CrashCallBack callback;
        private boolean mImmediately = false;
        private int uploadLimitCount = 2;
        private int mFingerprintThreshold = 0;
        private boolean mUploadToStatistic = false;
        private boolean mFilterNonVhallOfStat = false;
        private boolean mFilterNonVhallOfCollection = false;

        public Builder setDebug(boolean debug) {
            if (!debug) {
                this.uploadUrl = RELEASE_URL;
                this.uploadUrlStat = RELEASE_URL_STAT;
            }
            this.debug = debug;
            return this;
        }

        public Builder setCrashRootDir(String crashDir) {
            this.crashRootDir = crashDir;
            return this;
        }

        public Builder setUploadUrl(String url) {
            this.uploadUrl = url;
            return this;
        }

        public Builder setCallback(CrashCallBack callback) {
            this.callback = callback;
            return this;
        }

        public Builder addExtraFields(Map<String, String> extraFields) {
            if (this.extraFields == null) {
                this.extraFields = new HashMap<String, String>();
            }
            if (extraFields != null) {
                this.extraFields.putAll(extraFields);
            }
            return this;
        }

        public Builder addExtraField(String k, String v) {
            if (this.extraFields != null) {
                this.extraFields = new HashMap<String, String>();
            }
            this.extraFields.put(k, v);
            return this;
        }

        public Builder setImmediately(boolean immediately) {
            this.mImmediately = immediately;
            return this;
        }

        public Builder setUploadLimitCount(int count) {
            this.uploadLimitCount = count;
            return this;
        }

        public Builder setFingerprintThreshold(int threshold) {
            this.mFingerprintThreshold = threshold;
            return this;
        }

        public Builder uploadToStatistics(boolean uploadToStatistics) {
            this.mUploadToStatistic = uploadToStatistics;
            return this;
        }

        public Builder filterNonVhallOfStat(boolean filterNonVhall) {
            this.mFilterNonVhallOfStat = filterNonVhall;
            return this;
        }

        public Builder filterNonVhallOfCollection(boolean filterNonVhall) {
            this.mFilterNonVhallOfCollection = filterNonVhall;
            return this;
        }

        public ICrashConfig build() {
            return new ICrashConfig(){

                @Override
                public boolean isDebug() {
                    return Builder.this.debug;
                }

                @Override
                public String getCrashRootDir() {
                    return Builder.this.crashRootDir;
                }

                @Override
                public Map<String, String> getExtraFields() {
                    return Builder.this.extraFields;
                }

                @Override
                public String getUploadUrl() {
                    return Builder.this.uploadUrl;
                }

                @Override
                public String getStatUploadUrl() {
                    return Builder.this.uploadUrlStat;
                }

                @Override
                public CrashCallBack getCallBack() {
                    return Builder.this.callback;
                }

                @Override
                public boolean isImmediatelyUpload() {
                    return Builder.this.mImmediately;
                }

                @Override
                public int getUploadLimit() {
                    return Builder.this.uploadLimitCount;
                }

                @Override
                public int fingerprintThreshold() {
                    return Builder.this.mFingerprintThreshold;
                }

                @Override
                public boolean uploadToStatistic() {
                    return Builder.this.mUploadToStatistic;
                }

                @Override
                public boolean filterNonVhallOfStat() {
                    return Builder.this.mFilterNonVhallOfStat;
                }

                @Override
                public boolean filterNonVhallOfCollection() {
                    return Builder.this.mFilterNonVhallOfCollection;
                }

                @Override
                public String getExtraInfos() {
                    JSONObject jsonObject = new JSONObject();
                    if (Builder.this.extraFields != null) {
                        for (String k : Builder.this.extraFields.keySet()) {
                            try {
                                jsonObject.put(k, Builder.this.extraFields.get(k));
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (!VHCrashHandler.getRoomId().isEmpty()) {
                        try {
                            jsonObject.put("roomId", (Object)VHCrashHandler.getRoomId());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    return jsonObject.toString();
                }
            };
        }
    }
}

