/*
 * Decompiled with CFR 0.152.
 */
package contacts.debug;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import contacts.debug.LogKt;
import contacts.debug.LogPermissionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"logRawContactsTable", "", "Landroid/content/Context;", "contentUri", "Landroid/net/Uri;", "debug_release"})
public final class LogRawContactsTableKt {
    public static final void logRawContactsTable(@NotNull Context $this$logRawContactsTable) {
        Intrinsics.checkNotNullParameter((Object)$this$logRawContactsTable, (String)"<this>");
        if (!LogPermissionsKt.hasReadPermission($this$logRawContactsTable)) {
            LogKt.log("#### RawContacts table - read contacts permission not granted");
            return;
        }
        LogKt.log("#### RawContacts table");
        Uri uri = ContactsContract.RawContacts.CONTENT_URI;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"CONTENT_URI");
        LogRawContactsTableKt.logRawContactsTable($this$logRawContactsTable, uri);
    }

    public static final void logRawContactsTable(@NotNull Context $this$logRawContactsTable, @NotNull Uri contentUri) {
        Intrinsics.checkNotNullParameter((Object)$this$logRawContactsTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        String[] stringArray = new String[]{"_id", "contact_id", "sourceid", "display_name", "display_name_alt", "account_name", "account_type", "starred", "custom_ringtone", "send_to_voicemail", "deleted"};
        Cursor cursor = $this$logRawContactsTable.getContentResolver().query(contentUri, stringArray, null, null, null);
        if (cursor == null) {
            return;
        }
        while (cursor.moveToNext()) {
            String id = cursor.getString(0);
            String contactId = cursor.getString(1);
            String sourceId = cursor.getString(2);
            String displayNamePrimary = cursor.getString(3);
            String displayNameAlt = cursor.getString(4);
            String name = cursor.getString(5);
            String type = cursor.getString(6);
            String starred = cursor.getString(7);
            String customRingtone = cursor.getString(8);
            String sendToVoicemail = cursor.getString(9);
            String deleted = cursor.getString(10);
            LogKt.log(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                RawContact id: " + id + ", contactId: " + contactId + ", sourceId:" + sourceId + ",\n                 displayNamePrimary: " + displayNamePrimary + ", displayNameAlt: " + displayNameAlt + ",\n                 accountName: " + name + ", accountType: " + type + ",\n                 starred: " + starred + ", customRingtone: " + customRingtone + ",\n                 sendToVoicemail: " + sendToVoicemail + ", deleted: " + deleted + "\n            ")), (String)"\n", (String)"", (boolean)false, (int)4, null));
        }
        cursor.close();
    }
}

