/*
 * Decompiled with CFR 0.152.
 */
package contacts.debug;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import contacts.debug.LogKt;
import contacts.debug.LogPermissionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"logContactsTable", "", "Landroid/content/Context;", "contentUri", "Landroid/net/Uri;", "debug_release"})
public final class LogContactsTableKt {
    public static final void logContactsTable(@NotNull Context $this$logContactsTable) {
        Intrinsics.checkNotNullParameter((Object)$this$logContactsTable, (String)"<this>");
        if (!LogPermissionsKt.hasReadPermission($this$logContactsTable)) {
            LogKt.log("#### Contacts table - read contacts permission not granted");
            return;
        }
        LogKt.log("#### Contacts table");
        Uri uri = ContactsContract.Contacts.CONTENT_URI;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"CONTENT_URI");
        LogContactsTableKt.logContactsTable($this$logContactsTable, uri);
    }

    public static final void logContactsTable(@NotNull Context $this$logContactsTable, @NotNull Uri contentUri) {
        Intrinsics.checkNotNullParameter((Object)$this$logContactsTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        String[] stringArray = new String[]{"_id", "lookup", "display_name", "display_name_alt", "starred", "custom_ringtone", "send_to_voicemail", "photo_file_id", "photo_uri", "photo_thumb_uri", "has_phone_number"};
        Cursor cursor = $this$logContactsTable.getContentResolver().query(contentUri, stringArray, null, null, null);
        if (cursor == null) {
            return;
        }
        while (cursor.moveToNext()) {
            String id = cursor.getString(0);
            String lookupKey = cursor.getString(1);
            String displayNamePrimary = cursor.getString(2);
            String displayNameAlt = cursor.getString(3);
            String starred = cursor.getString(4);
            String customRingtone = cursor.getString(5);
            String sendToVoicemail = cursor.getString(6);
            String photoFileId = cursor.getString(7);
            String photoUri = cursor.getString(8);
            String photoThumbnailUri = cursor.getString(9);
            String hasPhoneNumber = cursor.getString(10);
            LogKt.log(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                Contact id: " + id + ", lookupKey: " + lookupKey + ",\n                 displayNamePrimary: " + displayNamePrimary + ", displayNameAlt: " + displayNameAlt + ", \n                 starred: " + starred + ", customRingtone: " + customRingtone + ", sendToVoicemail: " + sendToVoicemail + ",\n                 photoFileId: " + photoFileId + ", photoUri: " + photoUri + ", photoThumbnailUri: " + photoThumbnailUri + ",\n                 hasPhoneNumber: " + hasPhoneNumber + "\n            ")), (String)"\n", (String)"", (boolean)false, (int)4, null));
        }
        cursor.close();
    }
}

