/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.BundleContextFactory;
import com.github.veithen.cosmos.osgi.runtime.BundleImpl;
import com.github.veithen.cosmos.osgi.runtime.Element;
import com.github.veithen.cosmos.osgi.runtime.FrameworkImpl;
import com.github.veithen.cosmos.osgi.runtime.FrameworkUtilHelperImpl;
import com.github.veithen.cosmos.osgi.runtime.ParseException;
import com.github.veithen.cosmos.osgi.runtime.ResourceProcessor;
import com.github.veithen.cosmos.osgi.runtime.ResourceUtil;
import com.github.veithen.cosmos.osgi.runtime.internal.BundleLookup;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Requirement;

final class BundleManager
implements BundleLookup {
    private final AbstractBundle[] bundles;
    private final Map<String, AbstractBundle> bundlesBySymbolicName = new HashMap<String, AbstractBundle>();
    private final Map<URL, Bundle> bundlesByUrl = new HashMap<URL, Bundle>();
    private final Map<String, List<BundleImpl>> packageMap = new HashMap<String, List<BundleImpl>>();

    BundleManager() throws BundleException {
        final ArrayList<FrameworkImpl> bundles = new ArrayList<FrameworkImpl>();
        FrameworkImpl systemBundle = new FrameworkImpl(this);
        bundles.add(systemBundle);
        ResourceUtil.processResources("META-INF/MANIFEST.MF", new ResourceProcessor(){

            @Override
            public void process(URL url, InputStream in) throws IOException, BundleException {
                URL rootUrl;
                Manifest manifest = new Manifest(in);
                Attributes attrs = manifest.getMainAttributes();
                String symbolicName = attrs.getValue("Bundle-SymbolicName");
                if (symbolicName == null) {
                    return;
                }
                int idx = symbolicName.indexOf(59);
                if (idx != -1) {
                    symbolicName = symbolicName.substring(0, idx);
                }
                try {
                    rootUrl = new URL(url, "..");
                }
                catch (MalformedURLException ex) {
                    throw new BundleException("Unexpected exception", (Throwable)ex);
                }
                BundleImpl bundle = new BundleImpl(BundleManager.this, bundles.size(), symbolicName, attrs, rootUrl);
                bundles.add(bundle);
                BundleManager.this.bundlesBySymbolicName.put(symbolicName, bundle);
                BundleManager.this.bundlesByUrl.put(bundle.getLocationUrl(), bundle);
                String exportPackage = attrs.getValue("Export-Package");
                if (exportPackage != null) {
                    Element[] elements;
                    try {
                        elements = Element.parseHeaderValue(exportPackage);
                    }
                    catch (ParseException ex) {
                        throw new BundleException("Unable to parse Export-Package header", 3, (Throwable)ex);
                    }
                    for (Element element : elements) {
                        BundleManager.this.packageMap.computeIfAbsent(element.getValue(), k -> new ArrayList()).add(bundle);
                    }
                }
            }
        });
        this.bundles = bundles.toArray(new AbstractBundle[bundles.size()]);
    }

    void initialize(BundleContextFactory bundleContextFactory) throws BundleException {
        for (AbstractBundle bundle : this.bundles) {
            bundle.initialize(bundleContextFactory);
        }
        FrameworkUtilHelperImpl.setBundleLookup(this);
    }

    AbstractBundle[] getBundles() {
        return (AbstractBundle[])this.bundles.clone();
    }

    Bundle getBundle(String symbolicName) {
        return this.bundlesBySymbolicName.get(symbolicName);
    }

    List<BundleImpl> getBundlesByPackage(String pkg) {
        return this.packageMap.get(pkg);
    }

    AbstractBundle getBundle(long id) {
        return id < (long)this.bundles.length ? this.bundles[(int)id] : null;
    }

    @Override
    public Bundle getBundle(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : this.bundlesByUrl.get(codeSource.getLocation());
    }

    void fireBundleEvent(BundleImpl bundleImpl, int type) {
        BundleEvent event = new BundleEvent(type, (Bundle)bundleImpl);
        for (AbstractBundle bundle : this.bundles) {
            bundle.distributeBundleEvent(event);
        }
    }

    Collection<BundleCapability> findProviders(Requirement requirement) {
        Filter filter;
        String namespace = requirement.getNamespace();
        String filterSpec = (String)requirement.getDirectives().get("filter");
        if (filterSpec == null) {
            filter = null;
        } else {
            try {
                filter = FrameworkUtil.createFilter((String)filterSpec);
            }
            catch (InvalidSyntaxException ex) {
                return Collections.emptyList();
            }
        }
        ArrayList<BundleCapability> capabilities = new ArrayList<BundleCapability>();
        for (AbstractBundle bundle : this.bundles) {
            for (BundleCapability capability : bundle.getDeclaredCapabilities(namespace)) {
                if (capability == null || filter != null && !filter.matches(capability.getAttributes())) continue;
                capabilities.add(capability);
            }
        }
        return capabilities;
    }
}

