/*
 * Decompiled with CFR 0.152.
 */
package com.veeyaar.supergradienttextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.veeyaar.supergradienttextview.R;

@SuppressLint(value={"AppCompatCustomView"})
public class GradientTextView
extends TextView {
    private boolean isVertical;
    private int startColor = -16776961;
    private int endColor = -16711936;

    public GradientTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public GradientTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public GradientTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.GradientTextView);
            this.isVertical = attributes.getBoolean(R.styleable.GradientTextView_isVertical, false);
            this.startColor = attributes.getColor(R.styleable.GradientTextView_endColor, this.startColor);
            this.endColor = attributes.getColor(R.styleable.GradientTextView_startColor, this.endColor);
            attributes.recycle();
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            TextPaint paint = this.getPaint();
            float width = paint.measureText(this.getText().toString());
            if (this.isVertical) {
                this.getPaint().setShader((Shader)new LinearGradient(0.0f, 0.0f, width, (float)this.getLineHeight(), this.endColor, this.startColor, Shader.TileMode.CLAMP));
            } else {
                this.getPaint().setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getLineHeight(), this.endColor, this.startColor, Shader.TileMode.CLAMP));
            }
        }
    }
}

