/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PositionedStyledText {
    private final float x;
    private final float y;
    private final String text;
    private final PDFont font;
    private final int fontSize;
    private final Color color;

    PositionedStyledText(float x, float y, String text, PDFont font, int fontSize, Color color) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
    }

    public static PositionedStyledTextBuilder builder() {
        return new PositionedStyledTextBuilder();
    }

    public PositionedStyledTextBuilder toBuilder() {
        return new PositionedStyledTextBuilder().x(this.x).y(this.y).text(this.text).font(this.font).fontSize(this.fontSize).color(this.color);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public String getText() {
        return this.text;
    }

    public PDFont getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public static class PositionedStyledTextBuilder {
        private float x;
        private float y;
        private String text;
        private PDFont font;
        private int fontSize;
        private Color color;

        PositionedStyledTextBuilder() {
        }

        public PositionedStyledTextBuilder x(float x) {
            this.x = x;
            return this;
        }

        public PositionedStyledTextBuilder y(float y) {
            this.y = y;
            return this;
        }

        public PositionedStyledTextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public PositionedStyledTextBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public PositionedStyledTextBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public PositionedStyledTextBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public PositionedStyledText build() {
            return new PositionedStyledText(this.x, this.y, this.text, this.font, this.fontSize, this.color);
        }

        public String toString() {
            return "PositionedStyledText.PositionedStyledTextBuilder(x=" + this.x + ", y=" + this.y + ", text=" + this.text + ", font=" + this.font + ", fontSize=" + this.fontSize + ", color=" + this.color + ")";
        }
    }
}

