/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.util.PdfUtil;

public abstract class AbstractTextCell
extends AbstractCell {
    protected Color textColor;
    protected float lineSpacing;
    private Float textHeight;

    public PDFont getFont() {
        return this.settings.getFont();
    }

    public Integer getFontSize() {
        return this.settings.getFontSize();
    }

    public Color getTextColor() {
        return this.settings.getTextColor();
    }

    public abstract String getText();

    @Override
    public float getMinHeight() {
        return this.getVerticalPadding() + this.getTextHeight() > super.getMinHeight() ? this.getVerticalPadding() + this.getTextHeight() : super.getMinHeight();
    }

    public float getTextHeight() {
        if (this.textHeight != null) {
            return this.textHeight.floatValue();
        }
        this.textHeight = Float.valueOf(PdfUtil.getFontHeight(this.getFont(), this.getFontSize()));
        if (this.settings.isWordBreak()) {
            int size = PdfUtil.getOptimalTextBreakLines(this.getText(), this.getFont(), this.getFontSize(), this.getMaxWidth()).size();
            float heightOfTextLines = (float)size * this.textHeight.floatValue();
            float heightOfLineSpacing = (float)(size - 1) * this.textHeight.floatValue() * this.getLineSpacing();
            this.textHeight = Float.valueOf(heightOfTextLines + heightOfLineSpacing);
        }
        return this.textHeight.floatValue();
    }

    public float getWidthOfText() {
        this.assertIsRendered();
        float notBrokenTextWidth = PdfUtil.getStringWidth(this.getText(), this.getFont(), this.getFontSize());
        if (this.settings.isWordBreak()) {
            float maxWidth = this.getMaxWidthOfText() - this.getHorizontalPadding();
            List<String> textLines = PdfUtil.getOptimalTextBreakLines(this.getText(), this.getFont(), this.getFontSize(), maxWidth);
            return textLines.stream().map(line -> Float.valueOf(PdfUtil.getStringWidth(line, this.getFont(), this.getFontSize()))).max(Comparator.naturalOrder()).orElse(Float.valueOf(notBrokenTextWidth)).floatValue();
        }
        return notBrokenTextWidth;
    }

    private float getMaxWidthOfText() {
        float columnsWidth = this.getColumn().getWidth();
        if (this.getColSpan() > 1) {
            Column currentColumn = this.getColumn();
            for (int i = 1; i < this.getColSpan(); ++i) {
                columnsWidth += currentColumn.getNext().getWidth();
                currentColumn = currentColumn.getNext();
            }
        }
        return columnsWidth;
    }

    public float getMaxWidth() {
        return this.getMaxWidthOfText() - this.getHorizontalPadding();
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    protected AbstractTextCell(AbstractTextCellBuilder<?, ?> b) {
        super(b);
        this.textColor = ((AbstractTextCellBuilder)b).textColor;
        this.lineSpacing = ((AbstractTextCellBuilder)b).lineSpacing$set ? ((AbstractTextCellBuilder)b).lineSpacing$value : AbstractTextCell.$default$lineSpacing();
        this.textHeight = ((AbstractTextCellBuilder)b).textHeight;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public static abstract class AbstractTextCellBuilder<C extends AbstractTextCell, B extends AbstractTextCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private Color textColor;
        private boolean lineSpacing$set;
        private float lineSpacing$value;
        private Float textHeight;

        public B font(PDFont font) {
            this.settings.setFont(font);
            return (B)this.self();
        }

        public B fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return (B)this.self();
        }

        public B textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AbstractTextCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AbstractTextCell instance, AbstractTextCellBuilder<?, ?> b) {
            b.textColor(instance.textColor);
            b.lineSpacing(instance.lineSpacing);
            b.textHeight(instance.textHeight);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B lineSpacing(float lineSpacing) {
            this.lineSpacing$value = lineSpacing;
            this.lineSpacing$set = true;
            return (B)this.self();
        }

        public B textHeight(Float textHeight) {
            this.textHeight = textHeight;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AbstractTextCell.AbstractTextCellBuilder(super=" + super.toString() + ", textColor=" + this.textColor + ", lineSpacing$value=" + this.lineSpacing$value + ", textHeight=" + this.textHeight + ")";
        }
    }
}

