/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.settings;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;

public class Settings {
    private PDFont font;
    private Integer fontSize;
    private Color textColor;
    private Color backgroundColor;
    private Color borderColor;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Boolean wordBreak;

    public boolean isWordBreak() {
        return this.wordBreak != null && this.wordBreak != false;
    }

    public void setWordBreak(boolean wordBreak) {
        this.wordBreak = wordBreak;
    }

    public void fillingMergeBy(Settings settings) {
        this.fillingMergeFontSettings(settings);
        this.fillingMergeColorSettings(settings);
        this.fillingMergeAlignmentSettings(settings);
        this.fillingMergeWordBreakSetting(settings);
    }

    private void fillingMergeWordBreakSetting(Settings settings) {
        if (this.wordBreak == null && settings.wordBreak != null) {
            this.wordBreak = settings.getWordBreak();
        }
    }

    private void fillingMergeColorSettings(Settings settings) {
        if (this.getTextColor() == null && settings.getTextColor() != null) {
            this.textColor = settings.getTextColor();
        }
        if (this.getBackgroundColor() == null && settings.getBackgroundColor() != null) {
            this.backgroundColor = settings.getBackgroundColor();
        }
        if (this.getBorderColor() == null && settings.getBorderColor() != null) {
            this.borderColor = settings.getBorderColor();
        }
    }

    private void fillingMergeAlignmentSettings(Settings settings) {
        if (this.getHorizontalAlignment() == null && settings.getHorizontalAlignment() != null) {
            this.horizontalAlignment = settings.getHorizontalAlignment();
        }
        if (this.getVerticalAlignment() == null && settings.getVerticalAlignment() != null) {
            this.verticalAlignment = settings.getVerticalAlignment();
        }
    }

    private void fillingMergeFontSettings(Settings settings) {
        if (this.getFont() == null && settings.getFont() != null) {
            this.font = settings.getFont();
        }
        if (this.getFontSize() == null && settings.getFontSize() != null) {
            this.fontSize = settings.getFontSize();
        }
    }

    Settings(PDFont font, Integer fontSize, Color textColor, Color backgroundColor, Color borderColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, Boolean wordBreak) {
        this.font = font;
        this.fontSize = fontSize;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.wordBreak = wordBreak;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    public PDFont getFont() {
        return this.font;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Integer this$fontSize = this.getFontSize();
        Integer other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !((Object)((Object)this$horizontalAlignment)).equals((Object)other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        if (this$verticalAlignment == null ? other$verticalAlignment != null : !((Object)((Object)this$verticalAlignment)).equals((Object)other$verticalAlignment)) {
            return false;
        }
        Boolean this$wordBreak = this.getWordBreak();
        Boolean other$wordBreak = other.getWordBreak();
        return !(this$wordBreak == null ? other$wordBreak != null : !((Object)this$wordBreak).equals(other$wordBreak));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Settings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Integer $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : ((Object)((Object)$horizontalAlignment)).hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : ((Object)((Object)$verticalAlignment)).hashCode());
        Boolean $wordBreak = this.getWordBreak();
        result = result * 59 + ($wordBreak == null ? 43 : ((Object)$wordBreak).hashCode());
        return result;
    }

    public String toString() {
        return "Settings(font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", textColor=" + this.getTextColor() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", horizontalAlignment=" + (Object)((Object)this.getHorizontalAlignment()) + ", verticalAlignment=" + (Object)((Object)this.getVerticalAlignment()) + ", wordBreak=" + this.getWordBreak() + ")";
    }

    Boolean getWordBreak() {
        return this.wordBreak;
    }

    public static class SettingsBuilder {
        private PDFont font;
        private Integer fontSize;
        private Color textColor;
        private Color backgroundColor;
        private Color borderColor;
        private HorizontalAlignment horizontalAlignment;
        private VerticalAlignment verticalAlignment;
        private Boolean wordBreak;

        SettingsBuilder() {
        }

        public SettingsBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public SettingsBuilder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public SettingsBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public SettingsBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public SettingsBuilder borderColor(Color borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public SettingsBuilder horizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public SettingsBuilder verticalAlignment(VerticalAlignment verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            return this;
        }

        public SettingsBuilder wordBreak(Boolean wordBreak) {
            this.wordBreak = wordBreak;
            return this;
        }

        public Settings build() {
            return new Settings(this.font, this.fontSize, this.textColor, this.backgroundColor, this.borderColor, this.horizontalAlignment, this.verticalAlignment, this.wordBreak);
        }

        public String toString() {
            return "Settings.SettingsBuilder(font=" + this.font + ", fontSize=" + this.fontSize + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ", borderColor=" + this.borderColor + ", horizontalAlignment=" + (Object)((Object)this.horizontalAlignment) + ", verticalAlignment=" + (Object)((Object)this.verticalAlignment) + ", wordBreak=" + this.wordBreak + ")";
        }
    }
}

