/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.RowIsTooHighException;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

public class TableDrawer {
    protected final Table table;
    protected PDPageContentStream contentStream;
    protected PDPage page;
    protected float startX;
    protected float startY;
    protected float endY;
    private float finalY;
    protected final List<BiConsumer<Drawer, DrawingContext>> drawerList = new LinkedList<BiConsumer<Drawer, DrawingContext>>();

    public void draw() {
        this.drawPage(new PageData(0, this.table.getRows().size()));
    }

    protected void drawPage(PageData pageData) {
        this.drawerList.forEach(drawer -> this.drawWithFunction(pageData, new Point2D.Float(this.startX, this.startY), (BiConsumer<Drawer, DrawingContext>)drawer));
    }

    private Queue<PageData> computeRowsOnPagesWithNewPageStartOf(float yOffsetOnNewPage) {
        LinkedList<PageData> dataForPages = new LinkedList<PageData>();
        float y = this.startY;
        int firstRowOnPage = 0;
        int lastRowOnPage = 0;
        for (Row row : this.table.getRows()) {
            if (this.isRowTooHighToBeDrawnOnPage(row, yOffsetOnNewPage)) {
                throw new RowIsTooHighException("There is a row that is too high to be drawn on a single page");
            }
            if (this.isNotDrawableOnPage(y, row)) {
                dataForPages.add(new PageData(firstRowOnPage, lastRowOnPage));
                y = yOffsetOnNewPage;
                firstRowOnPage = lastRowOnPage;
            }
            y -= row.getHeight();
            ++lastRowOnPage;
        }
        dataForPages.add(new PageData(firstRowOnPage, lastRowOnPage));
        return dataForPages;
    }

    private boolean isRowTooHighToBeDrawnOnPage(Row row, float yOffsetOnNewPage) {
        return row.getHeight() > yOffsetOnNewPage - this.endY;
    }

    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        PDDocument document = documentSupplier.get();
        float startOnNewPage = pageSupplier.get().getMediaBox().getHeight() - yOffset;
        Queue<PageData> pageDataQueue = this.computeRowsOnPagesWithNewPageStartOf(startOnNewPage);
        int i = 0;
        while (!pageDataQueue.isEmpty()) {
            PDPage pageToDrawOn;
            if (i > 0 || document.getNumberOfPages() == 0) {
                pageToDrawOn = pageSupplier.get();
                document.addPage(pageToDrawOn);
            } else {
                pageToDrawOn = document.getPage(document.getNumberOfPages() - 1);
            }
            try (PDPageContentStream newPageContentStream = new PDPageContentStream(document, pageToDrawOn, PDPageContentStream.AppendMode.APPEND, false);){
                this.contentStream(newPageContentStream).page(pageToDrawOn).drawPage(pageDataQueue.poll());
            }
            this.startY(pageToDrawOn.getMediaBox().getHeight() - yOffset);
            ++i;
        }
    }

    protected void drawWithFunction(PageData pageData, Point2D.Float startingPoint, BiConsumer<Drawer, DrawingContext> consumer) {
        float y = startingPoint.y;
        for (int rowIndex = pageData.firstRowOnPage; rowIndex < pageData.firstRowOnNextPage; ++rowIndex) {
            Row row = this.table.getRows().get(rowIndex);
            this.drawRow(new Point2D.Float(startingPoint.x, y -= row.getHeight()), row, rowIndex, consumer);
            this.finalY = y;
        }
    }

    protected void drawRow(Point2D.Float start, Row row, int rowIndex, BiConsumer<Drawer, DrawingContext> consumer) {
        float x = start.x;
        int columnCounter = 0;
        for (AbstractCell cell : row.getCells()) {
            while (this.table.isRowSpanAt(rowIndex, columnCounter)) {
                x += this.table.getColumns().get(columnCounter).getWidth();
                ++columnCounter;
            }
            consumer.accept(cell.getDrawer(), new DrawingContext(this.contentStream, this.page, new Point2D.Float(x, start.y)));
            x += cell.getWidth();
            columnCounter += cell.getColSpan();
        }
    }

    private boolean isNotDrawableOnPage(float startY, Row row) {
        return startY - this.getHighestCellOf(row).floatValue() < this.endY;
    }

    private Float getHighestCellOf(Row row) {
        return row.getCells().stream().map(AbstractCell::getHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight()));
    }

    protected TableDrawer(TableDrawerBuilder<?, ?> b) {
        this.drawerList.add((drawer, drawingContext) -> {
            drawer.drawBackground((DrawingContext)drawingContext);
            drawer.drawContent((DrawingContext)drawingContext);
        });
        this.drawerList.add(Drawer::drawBorders);
        this.table = ((TableDrawerBuilder)b).table;
        this.contentStream = ((TableDrawerBuilder)b).contentStream;
        this.page = ((TableDrawerBuilder)b).page;
        this.startX = ((TableDrawerBuilder)b).startX;
        this.startY = ((TableDrawerBuilder)b).startY;
        this.endY = ((TableDrawerBuilder)b).endY;
        this.finalY = ((TableDrawerBuilder)b).finalY;
    }

    public static TableDrawerBuilder<?, ?> builder() {
        return new TableDrawerBuilderImpl();
    }

    public TableDrawerBuilder<?, ?> toBuilder() {
        return new TableDrawerBuilderImpl().$fillValuesFrom(this);
    }

    public TableDrawer contentStream(PDPageContentStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public TableDrawer page(PDPage page) {
        this.page = page;
        return this;
    }

    public TableDrawer startX(float startX) {
        this.startX = startX;
        return this;
    }

    public TableDrawer startY(float startY) {
        this.startY = startY;
        return this;
    }

    public float getFinalY() {
        return this.finalY;
    }

    private static final class TableDrawerBuilderImpl
    extends TableDrawerBuilder<TableDrawer, TableDrawerBuilderImpl> {
        private TableDrawerBuilderImpl() {
        }

        @Override
        protected TableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public TableDrawer build() {
            return new TableDrawer(this);
        }
    }

    public static abstract class TableDrawerBuilder<C extends TableDrawer, B extends TableDrawerBuilder<C, B>> {
        private Table table;
        private PDPageContentStream contentStream;
        private PDPage page;
        private float startX;
        private float startY;
        private float endY;
        private float finalY;

        protected B $fillValuesFrom(C instance) {
            TableDrawerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TableDrawer instance, TableDrawerBuilder<?, ?> b) {
            b.table(instance.table);
            b.contentStream(instance.contentStream);
            b.page(instance.page);
            b.startX(instance.startX);
            b.startY(instance.startY);
            b.endY(instance.endY);
            b.finalY(instance.finalY);
        }

        protected abstract B self();

        public abstract C build();

        public B table(Table table) {
            this.table = table;
            return this.self();
        }

        public B contentStream(PDPageContentStream contentStream) {
            this.contentStream = contentStream;
            return this.self();
        }

        public B page(PDPage page) {
            this.page = page;
            return this.self();
        }

        public B startX(float startX) {
            this.startX = startX;
            return this.self();
        }

        public B startY(float startY) {
            this.startY = startY;
            return this.self();
        }

        public B endY(float endY) {
            this.endY = endY;
            return this.self();
        }

        public B finalY(float finalY) {
            this.finalY = finalY;
            return this.self();
        }

        public String toString() {
            return "TableDrawer.TableDrawerBuilder(table=" + this.table + ", contentStream=" + this.contentStream + ", page=" + this.page + ", startX=" + this.startX + ", startY=" + this.startY + ", endY=" + this.endY + ", finalY=" + this.finalY + ")";
        }
    }

    public static class PageData {
        public final int firstRowOnPage;
        public final int firstRowOnNextPage;

        public PageData(int firstRowOnPage, int firstRowOnNextPage) {
            this.firstRowOnPage = firstRowOnPage;
            this.firstRowOnNextPage = firstRowOnNextPage;
        }
    }
}

