/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.geom.Point2D;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.cell.ImageCellDrawer;
import org.vandeseer.easytable.structure.cell.AbstractCell;

public class ImageCell
extends AbstractCell {
    @NonNull
    private PDImageXObject image;
    private float maxHeight;
    private final float scale;

    @Override
    public float getMinHeight() {
        return this.getFitSize().y + this.getVerticalPadding() > super.getMinHeight() ? this.getFitSize().y + this.getVerticalPadding() : super.getMinHeight();
    }

    @Override
    protected Drawer createDefaultDrawer() {
        return new ImageCellDrawer(this);
    }

    public Point2D.Float getFitSize() {
        Point2D.Float sizes = new Point2D.Float();
        float scaledWidth = (float)this.image.getWidth() * this.getScale();
        float scaledHeight = (float)this.image.getHeight() * this.getScale();
        float resultingWidth = this.getColumn().getWidth() - this.getHorizontalPadding();
        if (scaledWidth > resultingWidth) {
            scaledHeight = resultingWidth / scaledWidth * scaledHeight;
            scaledWidth = resultingWidth;
        }
        if (this.maxHeight > 0.0f && scaledHeight > this.maxHeight) {
            scaledWidth = this.maxHeight / scaledHeight * scaledWidth;
            scaledHeight = this.maxHeight;
        }
        sizes.x = scaledWidth;
        sizes.y = scaledHeight;
        return sizes;
    }

    private static float $default$scale() {
        return 1.0f;
    }

    protected ImageCell(ImageCellBuilder<?, ?> b) {
        super(b);
        this.image = ((ImageCellBuilder)b).image;
        if (this.image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.maxHeight = ((ImageCellBuilder)b).maxHeight;
        this.scale = ((ImageCellBuilder)b).scale$set ? ((ImageCellBuilder)b).scale$value : ImageCell.$default$scale();
    }

    public static ImageCellBuilder<?, ?> builder() {
        return new ImageCellBuilderImpl();
    }

    public ImageCellBuilder<?, ?> toBuilder() {
        return new ImageCellBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public PDImageXObject getImage() {
        return this.image;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public float getScale() {
        return this.scale;
    }

    private static final class ImageCellBuilderImpl
    extends ImageCellBuilder<ImageCell, ImageCellBuilderImpl> {
        private ImageCellBuilderImpl() {
        }

        @Override
        protected ImageCellBuilderImpl self() {
            return this;
        }

        @Override
        public ImageCell build() {
            return new ImageCell(this);
        }
    }

    public static abstract class ImageCellBuilder<C extends ImageCell, B extends ImageCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private PDImageXObject image;
        private float maxHeight;
        private boolean scale$set;
        private float scale$value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ImageCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ImageCell instance, ImageCellBuilder<?, ?> b) {
            b.image(instance.image);
            b.maxHeight(instance.maxHeight);
            b.scale(instance.scale);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B image(@NonNull PDImageXObject image) {
            if (image == null) {
                throw new NullPointerException("image is marked non-null but is null");
            }
            this.image = image;
            return (B)this.self();
        }

        public B maxHeight(float maxHeight) {
            this.maxHeight = maxHeight;
            return (B)this.self();
        }

        public B scale(float scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ImageCell.ImageCellBuilder(super=" + super.toString() + ", image=" + this.image + ", maxHeight=" + this.maxHeight + ", scale$value=" + this.scale$value + ")";
        }
    }
}

