/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

public class ImageCellDrawer
implements Drawer {
    private ImageCell cell;

    public ImageCellDrawer() {
    }

    public ImageCellDrawer(ImageCell cell) {
        this.cell = cell;
    }

    @Override
    public void setCell(AbstractCell cell) {
        this.cell = (ImageCell)cell;
    }

    @Override
    public void draw(DrawingContext drawingContext) throws IOException {
        PDPageContentStream contentStream = drawingContext.getContentStream();
        float moveX = drawingContext.getStartingPoint().x;
        float moveY = drawingContext.getStartingPoint().y;
        Point2D.Float size = this.cell.getFitSize();
        Point2D.Float drawAt = new Point2D.Float();
        float yStartRelative = this.cell.getRow().getHeight() - this.cell.getPaddingTop();
        if (this.cell.getRow().getHeight() > this.cell.getHeight() || this.cell.getRowSpan() > 1) {
            if (this.cell.getSettings().getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                float outerHeight = this.cell.getRowSpan() > 1 ? this.cell.getHeight() : this.cell.getRow().getHeight();
                yStartRelative = outerHeight / 2.0f + size.y / 2.0f;
                if (this.cell.getRowSpan() > 1) {
                    float rowSpanAdaption = this.cell.calculateHeightForRowSpan() - this.cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            } else if (this.cell.getSettings().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                yStartRelative = size.y + this.cell.getPaddingBottom();
                if (this.cell.getRowSpan() > 1) {
                    float rowSpanAdaption = this.cell.calculateHeightForRowSpan() - this.cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            }
        }
        float xOffset = moveX + this.cell.getPaddingLeft();
        if (this.cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
            xOffset = moveX + (this.cell.getWidth() - (size.x + this.cell.getPaddingRight()));
        } else if (this.cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
            float diff = (this.cell.getWidth() - size.x) / 2.0f;
            xOffset = moveX + diff;
        }
        drawAt.x = xOffset;
        drawAt.y = moveY + yStartRelative - size.y;
        contentStream.drawImage(this.cell.getImage(), drawAt.x, drawAt.y, size.x, size.y);
    }
}

