/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.cell.CellBaseData;
import org.vandeseer.easytable.util.PdfUtil;

public class CellText
extends CellBaseData {
    @NonNull
    private String text;
    private Color textColor;
    private float lineSpacing;

    public PDFont getFont() {
        return this.settings.getFont();
    }

    public Integer getFontSize() {
        return this.settings.getFontSize();
    }

    public Color getTextColor() {
        return this.settings.getTextColor();
    }

    @Override
    public float getHeight() {
        this.assertIsRendered();
        return this.getRowSpan() > 1 ? this.calculateHeightForRowSpan() : this.getTextHeight() + this.getVerticalPadding();
    }

    public float getTextHeight() {
        float fontHeight = PdfUtil.getFontHeight(this.getFont(), this.getFontSize());
        if (this.settings.isWordBreak()) {
            int size = PdfUtil.getOptimalTextBreakLines(this.text, this.getFont(), this.getFontSize(), this.getWidthOfText()).size();
            float heightOfTextLines = (float)size * fontHeight;
            float heightOfLineSpacing = (float)(size - 1) * fontHeight * this.getLineSpacing();
            return heightOfTextLines + heightOfLineSpacing;
        }
        return fontHeight;
    }

    public float getWidthOfText() {
        this.assertIsRendered();
        float notBrokenTextWidth = PdfUtil.getStringWidth(this.text, this.getFont(), this.getFontSize());
        if (this.settings.isWordBreak()) {
            float columnsWidth = this.getColumn().getWidth();
            if (this.getColSpan() > 1) {
                Column currentColumn = this.getColumn();
                for (int i = 1; i < this.getColSpan(); ++i) {
                    columnsWidth += currentColumn.getNext().getWidth();
                    currentColumn = currentColumn.getNext();
                }
            }
            float maxWidth = columnsWidth - this.getHorizontalPadding();
            List<String> textLines = PdfUtil.getOptimalTextBreakLines(this.text, this.getFont(), this.getFontSize(), maxWidth);
            return textLines.stream().map(line -> Float.valueOf(PdfUtil.getStringWidth(line, this.getFont(), this.getFontSize()))).max(Comparator.naturalOrder()).orElse(Float.valueOf(notBrokenTextWidth)).floatValue();
        }
        return notBrokenTextWidth;
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    protected CellText(CellTextBuilder<?, ?> b) {
        super(b);
        this.text = ((CellTextBuilder)b).text;
        if (this.text == null) {
            throw new NullPointerException("text is marked @NonNull but is null");
        }
        this.textColor = ((CellTextBuilder)b).textColor;
        this.lineSpacing = ((CellTextBuilder)b).lineSpacing$set ? ((CellTextBuilder)b).lineSpacing : CellText.$default$lineSpacing();
    }

    public static CellTextBuilder<?, ?> builder() {
        return new CellTextBuilderImpl();
    }

    public CellTextBuilder<?, ?> toBuilder() {
        return new CellTextBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    private static final class CellTextBuilderImpl
    extends CellTextBuilder<CellText, CellTextBuilderImpl> {
        private CellTextBuilderImpl() {
        }

        @Override
        protected CellTextBuilderImpl self() {
            return this;
        }

        @Override
        public CellText build() {
            return new CellText(this);
        }
    }

    public static abstract class CellTextBuilder<C extends CellText, B extends CellTextBuilder<C, B>>
    extends CellBaseData.CellBaseDataBuilder<C, B> {
        private String text;
        private Color textColor;
        private boolean lineSpacing$set;
        private float lineSpacing;

        public B font(PDFont font) {
            this.settings.setFont(font);
            return (B)this.self();
        }

        public B fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return (B)this.self();
        }

        public B textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CellTextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CellText instance, CellTextBuilder<?, ?> b) {
            b.text(instance.text);
            b.textColor(instance.textColor);
            b.lineSpacing(instance.lineSpacing);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked @NonNull but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        public B lineSpacing(float lineSpacing) {
            this.lineSpacing = lineSpacing;
            this.lineSpacing$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CellText.CellTextBuilder(super=" + super.toString() + ", text=" + this.text + ", textColor=" + this.textColor + ", lineSpacing=" + this.lineSpacing + ")";
        }
    }
}

