/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PdfUtil {
    private static final String NEW_LINE_REGEX = "\\r?\\n";
    private static final double EPSILON = 1.0E-4;

    private PdfUtil() {
    }

    public static float getStringWidth(String text, PDFont font, int fontSize) {
        return Arrays.stream(text.split(NEW_LINE_REGEX)).max(Comparator.comparing(String::length)).map(x -> Float.valueOf(PdfUtil.getWidthOfStringWithoutNewlines(x, font, fontSize))).orElseThrow(CouldNotDetermineStringWidthException::new).floatValue();
    }

    private static float getWidthOfStringWithoutNewlines(String str, PDFont font, int fontSize) {
        try {
            return font.getStringWidth(str) * (float)fontSize / 1000.0f;
        }
        catch (IOException exception) {
            throw new CouldNotDetermineStringWidthException(exception);
        }
    }

    public static float getFontHeight(PDFont font, int fontSize) {
        return font.getFontDescriptor().getCapHeight() * (float)fontSize / 1000.0f;
    }

    public static List<String> getOptimalTextBreakLines(String text, PDFont font, int fontSize, float maxWidth) {
        LinkedList<String> result = new LinkedList<String>();
        for (String line : text.split(NEW_LINE_REGEX)) {
            if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
                result.add(line);
                continue;
            }
            result.addAll(PdfUtil.wrapLine(line, font, fontSize, maxWidth));
        }
        return result;
    }

    private static List<String> wrapLine(String line, PDFont font, int fontSize, float maxWidth) {
        if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
            return Collections.singletonList(line);
        }
        List<String> resultLines = PdfUtil.splitByWords(line, font, fontSize, maxWidth);
        if (resultLines.isEmpty()) {
            resultLines.addAll(PdfUtil.splitBySize(line, font, fontSize, maxWidth));
        }
        return resultLines;
    }

    private static List<String> splitBySize(String line, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = line.length() - 1; i > 0; --i) {
            String fittedNewLine = line.substring(0, i) + "-";
            String remains = line.substring(i);
            if (!PdfUtil.doesTextLineFit(fittedNewLine, font, fontSize, maxWidth)) continue;
            returnList.add(fittedNewLine);
            returnList.addAll(PdfUtil.wrapLine(remains, font, fontSize, maxWidth));
            break;
        }
        return returnList;
    }

    private static List<String> splitByWords(String line, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> returnList = new ArrayList<String>();
        List<String> splitBySpace = Arrays.asList(line.split(" "));
        for (int i = splitBySpace.size() - 1; i >= 0; --i) {
            String fittedNewLine = String.join((CharSequence)" ", splitBySpace.subList(0, i));
            String remains = String.join((CharSequence)" ", splitBySpace.subList(i, splitBySpace.size()));
            if (fittedNewLine.isEmpty() || !PdfUtil.doesTextLineFit(fittedNewLine, font, fontSize, maxWidth)) continue;
            returnList.add(fittedNewLine);
            if (Objects.equals(remains, line)) break;
            returnList.addAll(PdfUtil.wrapLine(remains, font, fontSize, maxWidth));
            break;
        }
        return returnList;
    }

    private static boolean doesTextLineFit(String textLine, PDFont font, int fontSize, float maxWidth) {
        float stringWidth = PdfUtil.getStringWidth(textLine, font, fontSize);
        float difference = Math.abs(maxWidth - stringWidth);
        if ((double)difference < 1.0E-4) {
            return true;
        }
        return maxWidth > stringWidth;
    }

    private static class CouldNotDetermineStringWidthException
    extends RuntimeException {
        CouldNotDetermineStringWidthException() {
        }

        CouldNotDetermineStringWidthException(Exception exception) {
            super(exception);
        }
    }
}

