/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure;

import java.awt.Color;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.TableNotYetBuiltException;
import org.vandeseer.easytable.structure.cell.CellBaseData;

public class Row {
    private Table table;
    private List<CellBaseData> cells;
    private Settings settings;
    private float height;

    private Row(List<CellBaseData> cells) {
        this.cells = cells;
    }

    public float getHeight() {
        if (this.table == null) {
            throw new TableNotYetBuiltException();
        }
        float maxCellHeight = this.getCells().stream().map(CellBaseData::getHeight).max(Comparator.naturalOrder()).orElseThrow(RuntimeException::new).floatValue();
        return Math.max(this.height, maxCellHeight);
    }

    public static RowBuilder builder() {
        return new RowBuilder();
    }

    private void setCells(List<CellBaseData> cells) {
        this.cells = cells;
    }

    private void setHeight(float height) {
        this.height = height;
    }

    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    public List<CellBaseData> getCells() {
        return this.cells;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static class RowBuilder {
        private Table table;
        private float height;
        private List<CellBaseData> cells = new LinkedList<CellBaseData>();
        private Settings settings = Settings.builder().build();

        private RowBuilder() {
        }

        public RowBuilder add(CellBaseData cell) {
            this.cells.add(cell);
            return this;
        }

        public RowBuilder font(PDFont font) {
            this.settings.setFont(font);
            return this;
        }

        public RowBuilder fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return this;
        }

        public RowBuilder textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return this;
        }

        public RowBuilder backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this;
        }

        public RowBuilder borderColor(Color borderColor) {
            this.settings.setBorderColor(borderColor);
            return this;
        }

        public RowBuilder horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this;
        }

        public RowBuilder verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this;
        }

        public RowBuilder wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this;
        }

        public Row build() {
            Row row = new Row(this.cells);
            row.settings = this.settings;
            row.height = this.height;
            return row;
        }

        public RowBuilder table(Table table) {
            this.table = table;
            return this;
        }

        public RowBuilder cells(List<CellBaseData> cells) {
            this.cells = cells;
            return this;
        }

        public RowBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public RowBuilder height(float height) {
            this.height = height;
            return this;
        }

        public String toString() {
            return "Row.RowBuilder(table=" + this.table + ", cells=" + this.cells + ", settings=" + this.settings + ", height=" + this.height + ")";
        }
    }
}

