/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.AbstractTestLoggerAssert;
import com.github.valfirst.slf4jtest.LevelAssert;
import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;

public class TestLoggerAssert
extends AbstractTestLoggerAssert<TestLoggerAssert> {
    private MdcComparator mdcComparator = MdcComparator.EXACT;

    protected TestLoggerAssert(TestLogger testLogger) {
        super(testLogger, TestLoggerAssert.class);
    }

    public TestLoggerAssert anyThread() {
        this.loggingEventsSupplier = ((TestLogger)this.actual)::getAllLoggingEvents;
        return this;
    }

    public TestLoggerAssert usingMdcComparator(MdcComparator mdcComparator) {
        this.mdcComparator = mdcComparator;
        return this;
    }

    public TestLoggerAssert hasLogged(Level level, String message, Object ... arguments) {
        return this.hasLogged(TestLoggerAssert.event(level, message, arguments));
    }

    public TestLoggerAssert hasLogged(Throwable throwable, Level level, String message, Object ... arguments) {
        return this.hasLogged(TestLoggerAssert.event(throwable, level, message, arguments));
    }

    public TestLoggerAssert hasLogged(LoggingEvent event) {
        return this.hasLogged(this.buildPredicate(event), "Failed to find event:%n  %s", event);
    }

    public TestLoggerAssert hasLogged(Predicate<LoggingEvent> predicate) {
        return this.hasLogged(predicate, "Failed to find log matching predicate", new Object[0]);
    }

    public TestLoggerAssert hasLogged(PredicateBuilder predicate) {
        return this.hasLogged(predicate.build());
    }

    public TestLoggerAssert hasNotLogged(Level level, String message, Object ... arguments) {
        return this.hasNotLogged(TestLoggerAssert.event(level, message, arguments));
    }

    public TestLoggerAssert hasNotLogged(Throwable throwable, Level level, String message, Object ... arguments) {
        return this.hasNotLogged(TestLoggerAssert.event(throwable, level, message, arguments));
    }

    public TestLoggerAssert hasNotLogged(LoggingEvent event) {
        return this.hasNotLogged(this.buildPredicate(event));
    }

    public TestLoggerAssert hasNotLogged(Predicate<LoggingEvent> predicate) {
        this.findEvent(predicate).ifPresent(loggingEvent -> this.failWithMessage("Found %s, even though we expected not to", new Object[]{loggingEvent}));
        return this;
    }

    public TestLoggerAssert hasNotLogged(PredicateBuilder predicate) {
        this.findEvent(predicate.build()).ifPresent(loggingEvent -> this.failWithMessage("Found %s, even though we expected not to", new Object[]{loggingEvent}));
        return this;
    }

    public LevelAssert hasLevel(Level level) {
        LevelAssert levelAssert = new LevelAssert((TestLogger)this.actual, level);
        levelAssert.loggingEventsSupplier = this.loggingEventsSupplier;
        return levelAssert;
    }

    private TestLoggerAssert hasLogged(Predicate<LoggingEvent> predicate, String failureMessage, Object ... arguments) {
        if (!this.findEvent(predicate).isPresent()) {
            String allEvents = ((List)this.loggingEventsSupplier.get()).stream().map(Objects::toString).reduce((first, second) -> first + "\n  - " + second).map(output -> "  - " + output).orElse("  <none>");
            Object[] newArguments = Arrays.copyOf(arguments, arguments.length + 1);
            newArguments[arguments.length] = allEvents;
            this.failWithMessage(failureMessage + "%n%nThe logger contained the following events:%n%s", newArguments);
        }
        return this;
    }

    private Predicate<LoggingEvent> buildPredicate(LoggingEvent event) {
        return new PredicateBuilder().withMarkers(event.getMarkers().toArray(new Marker[event.getMarkers().size()])).withKeyValuePairs(event.getKeyValuePairs().toArray(new KeyValuePair[event.getKeyValuePairs().size()])).withThrowable((Throwable)event.getThrowable().orElse(null)).withLevel(event.getLevel()).withMessage(event.getMessage()).withArguments(event.getArguments().toArray()).withMdc(event.getMdc(), this.mdcComparator).build();
    }

    private Optional<LoggingEvent> findEvent(Predicate<LoggingEvent> predicate) {
        return ((List)this.loggingEventsSupplier.get()).stream().filter(predicate).findFirst();
    }

    public static final class MdcComparator {
        public static final MdcComparator IGNORING = new MdcComparator((a, b) -> true);
        public static final MdcComparator EXACT = new MdcComparator((a, b) -> a.size() == b.size() && a.entrySet().containsAll(b.entrySet()));
        public static final MdcComparator CONTAINING = new MdcComparator((a, b) -> a.entrySet().containsAll(b.entrySet()));
        private final BiPredicate<Map<String, String>, Map<String, String>> compareFunction;

        private MdcComparator(BiPredicate<Map<String, String>, Map<String, String>> compareFunction) {
            this.compareFunction = compareFunction;
        }

        public boolean compare(Map<String, String> actual, Map<String, String> expected) {
            return this.compareFunction.test(actual, expected);
        }
    }

    public static class PredicateBuilder {
        private static final Predicate<LoggingEvent> IGNORE_PREDICATE = event -> true;
        private Predicate<LoggingEvent> messagePredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> argumentsPredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> markerPredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> keyValuePairsPredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> mdcPredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> throwablePredicate = IGNORE_PREDICATE;
        private Predicate<LoggingEvent> levelPredicate = IGNORE_PREDICATE;

        public static PredicateBuilder aLog() {
            return new PredicateBuilder();
        }

        public PredicateBuilder withLevel(Level level) {
            this.levelPredicate = event -> event.getLevel().equals((Object)level);
            return this;
        }

        @Deprecated
        public PredicateBuilder withMarker(Marker marker) {
            Marker[] markerArray;
            if (marker == null) {
                markerArray = new Marker[]{};
            } else {
                Marker[] markerArray2 = new Marker[1];
                markerArray = markerArray2;
                markerArray2[0] = marker;
            }
            return this.withMarkers(markerArray);
        }

        public PredicateBuilder withMarkers(Marker ... markers) {
            this.markerPredicate = event -> event.getMarkers().equals(Arrays.asList(markers));
            return this;
        }

        public PredicateBuilder withKeyValuePairs(KeyValuePair ... keyValuePair) {
            this.keyValuePairsPredicate = event -> event.getKeyValuePairs().equals(Arrays.asList(keyValuePair));
            return this;
        }

        public PredicateBuilder withMessage(String message) {
            return this.withMessage(message::equals);
        }

        public PredicateBuilder withMessage(Predicate<String> predicate) {
            this.messagePredicate = event -> predicate.test(event.getMessage());
            return this;
        }

        public PredicateBuilder withArguments(Object ... arguments) {
            return this.withArguments((Collection<Object> actualArgs) -> actualArgs.equals(Arrays.asList(arguments)));
        }

        public PredicateBuilder withArguments(Predicate<Collection<Object>> predicate) {
            this.argumentsPredicate = event -> predicate.test(event.getArguments());
            return this;
        }

        public PredicateBuilder withThrowable(Throwable throwable) {
            return this.withThrowable((Optional<Throwable> t) -> t.equals(Optional.ofNullable(throwable)));
        }

        public PredicateBuilder withThrowable(Predicate<Optional<Throwable>> predicate) {
            this.throwablePredicate = event -> predicate.test(event.getThrowable());
            return this;
        }

        public PredicateBuilder withMdc(Map<String, String> mdc, MdcComparator comparator) {
            this.mdcPredicate = event -> comparator.compare(event.getMdc(), mdc);
            return this;
        }

        public Predicate<LoggingEvent> build() {
            return this.levelPredicate.and(this.markerPredicate).and(this.keyValuePairsPredicate).and(this.messagePredicate).and(this.argumentsPredicate).and(this.throwablePredicate).and(this.mdcPredicate);
        }
    }
}

