/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.browserup.bup.mitm.exception.UncheckedIOException;
import com.google.common.io.CharStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ClasspathResourceUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String classpathResourceToString(String resource, Charset charset) throws UncheckedIOException {
        if (resource == null) {
            throw new IllegalArgumentException("Classpath resource to load cannot be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Character set cannot be null");
        }
        try (InputStream resourceAsStream = ClasspathResourceUtil.class.getResourceAsStream(resource);){
            if (resourceAsStream == null) {
                throw new UncheckedIOException(new FileNotFoundException("Unable to locate classpath resource: " + resource));
            }
            InputStreamReader resourceReader = new InputStreamReader(resourceAsStream, charset);
            String string = CharStreams.toString((Readable)resourceReader);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error occurred while reading classpath resource", e);
        }
    }
}

