/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.transformer;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.internal.util.reflection.NestedSetter;
import org.hibernate.transform.BasicTransformerAdapter;

public class FluentHibernateResultTransformer
extends BasicTransformerAdapter {
    private static final long serialVersionUID = 6825154815776629666L;
    private final Class<?> resultClass;
    private NestedSetter[] setters;

    public FluentHibernateResultTransformer(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        this.createCachedSetters(this.resultClass, aliases);
        Object result = InternalUtils.ClassUtils.newInstance(this.resultClass);
        for (int i = 0; i < aliases.length; ++i) {
            this.setters[i].set(result, tuple[i]);
        }
        return result;
    }

    private void createCachedSetters(Class<?> resultClass, String[] aliases) {
        if (this.setters == null) {
            this.setters = FluentHibernateResultTransformer.createSetters(resultClass, aliases);
        }
    }

    private static NestedSetter[] createSetters(Class<?> resultClass, String[] aliases) {
        NestedSetter[] result = new NestedSetter[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            result[i] = NestedSetter.create(resultClass, aliases[i]);
        }
        return result;
    }
}

