/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;

class HibernateQueryParameters {
    private final List<Parameter> parameters = InternalUtils.CollectionUtils.newArrayList();

    public HibernateQueryParameters() {
    }

    public HibernateQueryParameters(String name, Object val) {
        this.add(name, val);
    }

    public static final HibernateQueryParameters create() {
        return new HibernateQueryParameters();
    }

    public HibernateQueryParameters add(String name, Object val) {
        this.parameters.add(new Parameter(name, val));
        return this;
    }

    public void setParametersToQuery(Query query) {
        for (Parameter parameter : this.parameters) {
            parameter.setToQuery(query);
        }
    }

    private static final class Parameter {
        private final String name;
        private final Object val;

        public Parameter(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        public void setToQuery(Query query) {
            if (this.val instanceof Collection) {
                query.setParameterList(this.name, (Collection)this.val);
            } else {
                query.setParameter(this.name, this.val);
            }
        }
    }
}

