/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.IRequest;
import com.github.fluent.hibernate.cfg.HibernateSessionFactory;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.request.HibernateQueryParameters;
import com.github.fluent.hibernate.transformer.FluentHibernateResultTransformer;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;

class HibernateQuery<T> {
    private final HibernateQueryParameters params = new HibernateQueryParameters();
    private int maxResults;
    private ResultTransformer transformer;
    private IQueryFactory queryFactory;

    public HibernateQuery(IQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public HibernateQuery<T> p(String name, Object val) {
        this.params.add(name, val);
        return this;
    }

    public HibernateQuery<T> p(String name, Object ... vals) {
        this.params.add(name, Arrays.asList(vals));
        return this;
    }

    public HibernateQuery<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public HibernateQuery<T> transform(Class<?> clazz) {
        this.transformer = new FluentHibernateResultTransformer(clazz);
        return this;
    }

    public HibernateQuery<T> useTransformer(ResultTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public T first() {
        return InternalUtils.CollectionUtils.first(this.list());
    }

    public List<T> list() {
        return (List)HibernateSessionFactory.doInTransaction(new IRequest<List<T>>(){

            @Override
            public List<T> doInTransaction(Session session) {
                return HibernateQuery.this.tuneForSelect(HibernateQuery.this.createQuery(session)).list();
            }
        });
    }

    private Query tuneForSelect(Query hibernateQuery) {
        if (this.maxResults != 0) {
            hibernateQuery.setMaxResults(this.maxResults);
        }
        if (this.transformer != null) {
            hibernateQuery.setResultTransformer(this.transformer);
        }
        return hibernateQuery;
    }

    public int count() {
        Number result = HibernateSessionFactory.doInTransaction(new IRequest<Number>(){

            @Override
            public Number doInTransaction(Session session) {
                return (Number)HibernateQuery.this.createQuery(session).uniqueResult();
            }
        });
        return result == null ? 0 : result.intValue();
    }

    private Query createQuery(Session session) {
        Query result = this.queryFactory.create(session);
        this.params.setParametersToQuery(result);
        return result;
    }

    public static interface IQueryFactory {
        public Query create(Session var1);
    }
}

