/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.internal.util.reflection;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    public static final Class<?>[] NO_PARAM_SIGNATURE = new Class[0];
    public static final Class<?>[] SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};

    private ReflectionUtils() {
    }

    public static void makePublic(AccessibleObject accessibleObject) {
        if (accessibleObject != null) {
            accessibleObject.setAccessible(true);
        }
    }

    public static Method findGetterMethod(Class<?> rootClass, String propertyName) {
        Method result = null;
        for (Class<?> checkClass = rootClass; result == null && checkClass != null && !checkClass.equals(Object.class); checkClass = checkClass.getSuperclass()) {
            result = ReflectionUtils.getClassGetter(checkClass, propertyName);
        }
        if (result == null) {
            Class<?> theInterface;
            Class<?>[] classArray = rootClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = ReflectionUtils.getClassGetter(theInterface = classArray[i], propertyName)) == null; ++i) {
            }
        }
        return result;
    }

    public static Method getClassGetter(Class<?> classToCheck, String propertyName) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = ReflectionUtils.getPropertyDescriptors(classToCheck)) {
            if (!ReflectionUtils.isGetter(descriptor, propertyName)) continue;
            return descriptor.getReadMethod();
        }
        return null;
    }

    private static boolean isGetter(PropertyDescriptor descriptor, String propertyName) {
        Method method = descriptor.getReadMethod();
        return method != null && method.getParameterTypes().length == 0 && descriptor.getName().equalsIgnoreCase(propertyName);
    }

    public static Method getClassSetter(Class<?> classToCheck, String propertyName, Method getterMethod) {
        return ReflectionUtils.getClassSetter(classToCheck, propertyName, getterMethod == null ? null : getterMethod.getReturnType());
    }

    public static Method getClassSetter(Class<?> classToCheck, String propertyName, Class<?> propertyType) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = ReflectionUtils.getPropertyDescriptors(classToCheck)) {
            if (!ReflectionUtils.isSetter(descriptor, propertyName, propertyType)) continue;
            return descriptor.getWriteMethod();
        }
        return null;
    }

    private static boolean isSetter(PropertyDescriptor descriptor, String propertyName, Class<?> propertyType) {
        Method method = descriptor.getWriteMethod();
        return method != null && method.getParameterTypes().length == 1 && method.getName().startsWith("set") && descriptor.getName().equalsIgnoreCase(propertyName) && (propertyType == null || method.getParameterTypes()[0].equals(propertyType));
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        try {
            return Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            throw InternalUtils.toRuntimeException(ex);
        }
    }

    public static Field findField(Class<?> classToCheck, String propertyName) {
        if (classToCheck == null || Object.class.equals(classToCheck)) {
            return null;
        }
        try {
            return classToCheck.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException nsfe) {
            return ReflectionUtils.findField(classToCheck.getSuperclass(), propertyName);
        }
    }

    public static String[] getPropertyParts(String property) {
        return InternalUtils.StringUtils.splitByDot(property);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> classToCheck, String propertyName, Class<T> annotationClass) {
        T result = ReflectionUtils.getAnnotation(ReflectionUtils.findGetterMethod(classToCheck, propertyName), annotationClass);
        return result == null ? ReflectionUtils.getAnnotation(ReflectionUtils.findField(classToCheck, propertyName), annotationClass) : result;
    }

    private static <T extends Annotation> T getAnnotation(AccessibleObject accessibleObject, Class<T> annotationClass) {
        return accessibleObject == null ? null : (T)accessibleObject.getAnnotation(annotationClass);
    }

    public static Method extractMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        return clazz.getMethod(methodName, NO_PARAM_SIGNATURE);
    }

    public static <T> T invoke(Object thisObject, Method method) throws IllegalAccessException, InvocationTargetException {
        return (T)method.invoke(thisObject, (Object[])NO_PARAM_SIGNATURE);
    }

    public static Method extractMethod(Class<?> clazz, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterType);
    }

    public static <T> T invoke(Object thisObject, Method method, Object parameter) throws IllegalAccessException, InvocationTargetException {
        return (T)method.invoke(thisObject, parameter);
    }
}

