/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.internal.util.reflection;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.internal.util.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import org.hibernate.PropertyAccessException;

public final class NestedSetter {
    private final Class<?> clazz;
    private final Method[] getMethods;
    private final Method[] setMethods;
    private final Method method;
    private final String propertyName;

    private NestedSetter(Class<?> clazz, Method[] getMethods, Method[] setMethods, Method method, String propertyName) {
        this.clazz = clazz;
        this.method = method;
        this.propertyName = propertyName;
        this.getMethods = getMethods;
        this.setMethods = setMethods;
    }

    public void set(Object target, Object value) {
        try {
            this.invokeSet(target, value);
        }
        catch (Exception ex) {
            this.checkForPrimitive(value);
            String errorMessage = String.format("Setter information: expected type: %s, actual type: %s.", this.method.getParameterTypes()[0].getName(), value == null ? null : value.getClass().getName());
            throw new PropertyAccessException((Throwable)ex, errorMessage, true, this.clazz, this.propertyName);
        }
    }

    private void checkForPrimitive(Object value) {
        if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
            throw new PropertyAccessException(null, "Value is null, but property type is primitive.", true, this.clazz, this.propertyName);
        }
    }

    private void invokeSet(Object target, Object value) throws Exception {
        Object tmpTarget = target;
        for (int i = 0; i < this.getMethods.length; ++i) {
            Object tmpTarget2 = this.getMethods[i].invoke(tmpTarget, new Object[0]);
            if (tmpTarget2 == null) {
                tmpTarget2 = InternalUtils.ClassUtils.newInstance(this.getMethods[i].getReturnType());
                this.setMethods[i].invoke(tmpTarget, tmpTarget2);
            }
            tmpTarget = tmpTarget2;
        }
        this.method.invoke(tmpTarget, value);
    }

    public static NestedSetter create(Class<?> theClass, String propertyName) {
        NestedSetter result = NestedSetter.getSetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyAccessException(null, "Could not find a setter for a nested property.", true, theClass, propertyName);
        }
        return result;
    }

    private static NestedSetter getSetterOrNull(Class<?> theClass, String propertyName) {
        if (theClass == Object.class || theClass == null || propertyName == null) {
            return null;
        }
        String[] propertyParts = ReflectionUtils.getPropertyParts(propertyName);
        int nestedCount = propertyParts.length;
        Method[] getMethods = new Method[nestedCount - 1];
        Method[] setMethods = new Method[nestedCount - 1];
        Class<?> currentClass = theClass;
        for (int i = 0; i < nestedCount - 1; ++i) {
            Method getter = ReflectionUtils.getClassGetter(currentClass, propertyParts[i]);
            if (getter == null) {
                throw new PropertyAccessException(null, String.format("Intermediate getter property not found for nesetd property `%s`", propertyName), false, theClass, propertyParts[i]);
            }
            getMethods[i] = getter;
            setMethods[i] = ReflectionUtils.getClassSetter(currentClass, propertyParts[i], getter);
            currentClass = getMethods[i].getReturnType();
        }
        Method method = NestedSetter.setterMethod(currentClass, propertyParts[nestedCount - 1]);
        if (method != null) {
            ReflectionUtils.makePublic(method);
            return new NestedSetter(theClass, getMethods, setMethods, method, propertyName);
        }
        NestedSetter setter = NestedSetter.getSetterOrNull(theClass.getSuperclass(), propertyName);
        if (setter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; setter == null && i < interfaces.length; ++i) {
                setter = NestedSetter.getSetterOrNull(interfaces[i], propertyName);
            }
        }
        return setter;
    }

    private static Method setterMethod(Class<?> theClass, String propertyName) {
        Method getter = ReflectionUtils.getClassGetter(theClass, propertyName);
        return ReflectionUtils.getClassSetter(theClass, propertyName, getter);
    }
}

