/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy.hibernate5.adapter;

import com.github.fluent.hibernate.cfg.strategy.NamingStrategyUtils;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitAnyDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitAnyKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitTenantIdColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.naming.NamingHelper;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.NamingStrategy;

public class Hibernate4To5NamingStrategyAdapter
implements ImplicitNamingStrategy {
    private static final String ORDER_COLUMN_POSTFIX = "_ORDER";
    private static final String KEY_COLUMN_POSTFIX = "_KEY";
    private static final String FOREIGN_KEY_CONSTRAINT_PREFIX = "FK_";
    private static final String UNIQUE_CONSTRAINT_PREFIX = "UK_";
    private static final String INDEX_PREFIX = "UK_";
    private NamingStrategy hibernate4Strategy;

    public Hibernate4To5NamingStrategyAdapter(NamingStrategy hibernate4Strategy) {
        this.hibernate4Strategy = hibernate4Strategy;
    }

    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        String result = this.hibernate4Strategy.classToTableName(source.getEntityNaming().getEntityName());
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        String ownerEntity = source.getOwningEntityNaming().getEntityName();
        String ownerEntityTable = NamingStrategyUtils.unqualifyEntityName(ownerEntity);
        String associatedEntity = source.getNonOwningEntityNaming().getEntityName();
        String associatedEntityTable = NamingStrategyUtils.unqualifyEntityName(associatedEntity);
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(source.getAssociationOwningAttributePath());
        String result = this.hibernate4Strategy.collectionTableName(ownerEntity, ownerEntityTable, associatedEntity, associatedEntityTable, propertyName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source) {
        String ownerEntity = source.getOwningEntityNaming().getEntityName();
        String ownerEntityTable = NamingStrategyUtils.unqualifyEntityName(ownerEntity);
        String associatedEntity = null;
        String associatedEntityTable = null;
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(source.getOwningAttributePath());
        String result = this.hibernate4Strategy.collectionTableName(ownerEntity, ownerEntityTable, associatedEntity, associatedEntityTable, propertyName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source) {
        AttributePath attributePath = source.getAttributePath();
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(attributePath);
        String result = this.hibernate4Strategy.propertyToColumnName(propertyName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(source.getAttributePath());
        String propertyEntityName = source.getEntityNaming().getEntityName();
        String propertyTableName = NamingStrategyUtils.unqualifyEntityName(propertyEntityName);
        String referencedColumnName = source.getReferencedColumnName().getText();
        String result = this.hibernate4Strategy.foreignKeyColumnName(propertyName, propertyEntityName, propertyTableName, referencedColumnName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        String result = Hibernate4To5NamingStrategyAdapter.generateHashedConstraintName(FOREIGN_KEY_CONSTRAINT_PREFIX, source.getTableName(), source.getColumnNames());
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        String result = Hibernate4To5NamingStrategyAdapter.generateHashedConstraintName("UK_", source.getTableName(), source.getColumnNames());
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        String result = Hibernate4To5NamingStrategyAdapter.generateHashedConstraintName("UK_", source.getTableName(), source.getColumnNames());
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public static String generateHashedConstraintName(String prefix, Identifier tableName, List<Identifier> columnNames) {
        StringBuilder sb = new StringBuilder("table`" + tableName.getText() + "`");
        List<String> alphabeticalColumnNames = Hibernate4To5NamingStrategyAdapter.toString(columnNames);
        Collections.sort(alphabeticalColumnNames);
        for (String columnName : alphabeticalColumnNames) {
            sb.append("column`" + columnName + "`");
        }
        return prefix + NamingHelper.INSTANCE.hashedName(sb.toString());
    }

    private static List<String> toString(List<Identifier> columnNames) {
        ArrayList<String> result = InternalUtils.CollectionUtils.newArrayListWithCapacity(InternalUtils.CollectionUtils.size(columnNames));
        for (Identifier columnName : columnNames) {
            result.add(columnName.getText());
        }
        return result;
    }

    public Identifier determineDiscriminatorColumnName(ImplicitDiscriminatorColumnNameSource source) {
        String discriminatorColumnName = "DTYPE";
        String result = this.hibernate4Strategy.columnName(discriminatorColumnName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineListIndexColumnName(ImplicitIndexColumnNameSource source) {
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(source.getPluralAttributePath());
        String orderColumnName = propertyName + ORDER_COLUMN_POSTFIX;
        String result = this.hibernate4Strategy.columnName(orderColumnName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineMapKeyColumnName(ImplicitMapKeyColumnNameSource source) {
        String propertyName = Hibernate4To5NamingStrategyAdapter.getPropertyName(source.getPluralAttributePath());
        String orderColumnName = propertyName + KEY_COLUMN_POSTFIX;
        String result = this.hibernate4Strategy.columnName(orderColumnName);
        return Hibernate4To5NamingStrategyAdapter.toIdentifier(result, source.getBuildingContext());
    }

    public Identifier determineTenantIdColumnName(ImplicitTenantIdColumnNameSource source) {
        throw new UnsupportedOperationException();
    }

    public Identifier determineIdentifierColumnName(ImplicitIdentifierColumnNameSource source) {
        throw new UnsupportedOperationException();
    }

    public Identifier determinePrimaryKeyJoinColumnName(ImplicitPrimaryKeyJoinColumnNameSource source) {
        throw new UnsupportedOperationException();
    }

    public Identifier determineAnyDiscriminatorColumnName(ImplicitAnyDiscriminatorColumnNameSource source) {
        throw new UnsupportedOperationException();
    }

    public Identifier determineAnyKeyColumnName(ImplicitAnyKeyColumnNameSource source) {
        throw new UnsupportedOperationException();
    }

    private static String getPropertyName(AttributePath attributePath) {
        return attributePath == null ? null : attributePath.getProperty();
    }

    private static Identifier toIdentifier(String stringForm, MetadataBuildingContext buildingContext) {
        return buildingContext == null ? Identifier.toIdentifier((String)stringForm) : buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(stringForm);
    }
}

