/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy;

import com.github.fluent.hibernate.internal.util.InternalUtils;

public class StrategyOptions {
    private static final String COLUMN_PREFIX = "f_";
    private static final String FOREIGN_KEY_COLUMN_PREFIX = "fk_";
    private static final String FOREIGN_KEY_CONSTRAINT_PREFIX = "F_";
    private static final String UNIQUE_KEY_CONSTRAINT_PREFIX = "U_";
    private String tablePrefix;
    private String columnPrefix = "f_";
    private String foreignKeyColumnPrefix = "fk_";
    private String foreignKeyConstraintPrefix = "F_";
    private String uniqueKeyConstraintPrefix = "U_";
    private int maxLength;
    private boolean restrictTableNames = true;
    private boolean restrictColumnNames = true;
    private boolean restrictEmbeddedColumnNames = true;
    private boolean restrictJoinTableNames = true;
    private boolean restrictConstraintNames = true;
    public boolean autodetectMaxLength;

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    boolean hasTablePrefix() {
        return !InternalUtils.StringUtils.isEmpty(this.tablePrefix);
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    int getColumnPrefixLength() {
        return InternalUtils.StringUtils.length(this.columnPrefix);
    }

    boolean hasColumnPrefix() {
        return !InternalUtils.StringUtils.isEmpty(this.columnPrefix);
    }

    public String getForeignKeyColumnPrefix() {
        return this.foreignKeyColumnPrefix;
    }

    boolean hasForeignKeyColumnPrefix() {
        return !InternalUtils.StringUtils.isEmpty(this.foreignKeyColumnPrefix);
    }

    public String getForeignKeyConstraintPrefix() {
        return this.foreignKeyConstraintPrefix;
    }

    boolean hasForeignKeyConstraintPrefix() {
        return !InternalUtils.StringUtils.isEmpty(this.foreignKeyConstraintPrefix);
    }

    public String getUniqueKeyConstraintPrefix() {
        return this.uniqueKeyConstraintPrefix;
    }

    boolean hasUniqueKeyConstraintPrefix() {
        return !InternalUtils.StringUtils.isEmpty(this.uniqueKeyConstraintPrefix);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isRestrictTableNames() {
        return this.restrictTableNames;
    }

    public boolean isRestrictColumnNames() {
        return this.restrictColumnNames;
    }

    public boolean isRestrictEmbeddedColumnNames() {
        return this.restrictEmbeddedColumnNames;
    }

    public boolean isRestrictJoinTableNames() {
        return this.restrictJoinTableNames;
    }

    public boolean isRestrictConstraintNames() {
        return this.restrictConstraintNames;
    }

    public boolean isAutodetectMaxLength() {
        return this.autodetectMaxLength;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = InternalUtils.StringUtils.addSuffixIfNot(tablePrefix, '_');
    }

    public void setColumnPrefix(String columnPrefix) {
        this.columnPrefix = columnPrefix;
    }

    public void setForeignKeyColumnPrefix(String foreignKeyColumnPrefix) {
        this.foreignKeyColumnPrefix = foreignKeyColumnPrefix;
    }

    public void setForeignKeyConstraintPrefix(String foreignKeyConstraintPrefix) {
        this.foreignKeyConstraintPrefix = foreignKeyConstraintPrefix;
    }

    public void setUniqueKeyConstraintPrefix(String uniqueKeyConstraintPrefix) {
        this.uniqueKeyConstraintPrefix = uniqueKeyConstraintPrefix;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setRestrictTableNames(boolean restrictTableNames) {
        this.restrictTableNames = restrictTableNames;
    }

    public void setRestrictColumnNames(boolean restrictColumnNames) {
        this.restrictColumnNames = restrictColumnNames;
    }

    public void setRestrictEmbeddedColumnNames(boolean restrictEmbeddedColumnNames) {
        this.restrictEmbeddedColumnNames = restrictEmbeddedColumnNames;
    }

    public void setRestrictJoinTableNames(boolean restrictJoinTableNames) {
        this.restrictJoinTableNames = restrictJoinTableNames;
    }

    public void setRestrictConstraintNames(boolean restrictConstraintNames) {
        this.restrictConstraintNames = restrictConstraintNames;
    }

    public void setAutodetectMaxLength(boolean autodetectMaxLength) {
        this.autodetectMaxLength = autodetectMaxLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final StrategyOptions result = new StrategyOptions();

        public Builder tablePrefix(String tablePrefix) {
            this.result.setTablePrefix(tablePrefix);
            return this;
        }

        public Builder dontRestrictLength() {
            return this.restrictLength(0);
        }

        public Builder restrictLength(int maxLength) {
            this.result.maxLength = maxLength;
            return this;
        }

        public Builder columnPrefix(String columnPrefix) {
            this.result.columnPrefix = columnPrefix;
            return this;
        }

        public Builder foreignKeyColumnPrefix(String foreignKeyColumnPrefix) {
            this.result.foreignKeyColumnPrefix = foreignKeyColumnPrefix;
            return this;
        }

        public Builder foreignKeyConstraintPrefix(String foreignKeyConstraintPrefix) {
            this.result.foreignKeyConstraintPrefix = foreignKeyConstraintPrefix;
            return this;
        }

        public Builder uniqueKeyConstraintPrefix(String uniqueKeyConstraintPrefix) {
            this.result.uniqueKeyConstraintPrefix = uniqueKeyConstraintPrefix;
            return this;
        }

        public Builder restrictConstraintNames(boolean restrictConstraintNames) {
            this.result.setRestrictConstraintNames(restrictConstraintNames);
            return this;
        }

        public Builder restrictTableNames(boolean restrictTableNames) {
            this.result.restrictTableNames = restrictTableNames;
            return this;
        }

        public Builder restrictColumnNames(boolean restrictColumnNames) {
            this.result.restrictColumnNames = restrictColumnNames;
            return this;
        }

        public Builder restrictEmbeddedColumnNames(boolean restrictEmbeddedColumnNames) {
            this.result.restrictEmbeddedColumnNames = restrictEmbeddedColumnNames;
            return this;
        }

        public Builder restrictJoinTableNames(boolean restrictJoinTableNames) {
            this.result.restrictJoinTableNames = restrictJoinTableNames;
            return this;
        }

        public Builder withoutPrefixes() {
            this.result.tablePrefix = null;
            this.result.columnPrefix = null;
            this.result.foreignKeyColumnPrefix = null;
            this.result.foreignKeyConstraintPrefix = null;
            this.result.uniqueKeyConstraintPrefix = null;
            return this;
        }

        public Builder autodetectMaxLength() {
            this.result.autodetectMaxLength = true;
            return this;
        }

        public StrategyOptions build() {
            return this.result;
        }
    }
}

