/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.util.Locale;
import java.util.regex.Pattern;

public final class NamingStrategyUtils {
    public static final char NAME_PARTS_SEPARATOR = '_';
    private static final String NAME_PARTS_SEPARATOR_AS_STRING = String.valueOf('_');
    private static final String ES = "es";
    private static final Pattern END_SIS = Pattern.compile("^.*[sx]is$");
    private static final Pattern END_SH = Pattern.compile("^.*[sc]h$");
    private static final Pattern END_AY = Pattern.compile("^.*[aeijouy]y$");

    private NamingStrategyUtils() {
    }

    public static String propertyToPluralizedName(String property) {
        return NamingStrategyUtils.pluralize(NamingStrategyUtils.propertyToName(property));
    }

    public static String classToPluralizedName(String className) {
        return NamingStrategyUtils.pluralize(NamingStrategyUtils.classToName(className));
    }

    public static String propertyToName(String property) {
        return NamingStrategyUtils.addUnderscores(NamingStrategyUtils.unqualify(property));
    }

    public static String classToName(String className) {
        return NamingStrategyUtils.addUnderscores(InternalUtils.ClassUtils.getShortName(className));
    }

    public static String addUnderscores(String name) {
        StringBuilder result = new StringBuilder(name.replace('.', '_'));
        for (int i = 1; i < result.length() - 1; ++i) {
            if (!Character.isLowerCase(result.charAt(i - 1)) || !Character.isUpperCase(result.charAt(i)) || !Character.isLowerCase(result.charAt(i + 1))) continue;
            result.insert(i++, '_');
        }
        return result.toString().toLowerCase(Locale.ROOT);
    }

    public static String unqualifyEntityName(String entityName) {
        String result = NamingStrategyUtils.unqualify(entityName);
        int slashPos = result.indexOf(47);
        if (slashPos > 0) {
            result = result.substring(0, slashPos - 1);
        }
        return result;
    }

    public static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }

    public static String concat(String left, String right) {
        return InternalUtils.StringUtils.join(left, right, NAME_PARTS_SEPARATOR_AS_STRING);
    }

    public static String concat(String[] parts) {
        return InternalUtils.StringUtils.join(parts, NAME_PARTS_SEPARATOR_AS_STRING);
    }

    public static String pluralize(String name) {
        if (name.endsWith(ES)) {
            return name;
        }
        StringBuilder plural = new StringBuilder(name);
        if (name.endsWith("s")) {
            if (NamingStrategyUtils.matches(name, END_SIS)) {
                plural.setCharAt(plural.length() - 2, 'e');
            } else {
                plural.append(ES);
            }
        } else if (name.endsWith("z") || name.endsWith("x") || NamingStrategyUtils.matches(name, END_SH)) {
            plural.append(ES);
        } else if (name.endsWith("y")) {
            if (!NamingStrategyUtils.matches(name, END_AY)) {
                plural.setCharAt(plural.length() - 1, 'i');
                plural.append('e');
            }
            plural.append('s');
        } else {
            plural.append('s');
        }
        return plural.toString();
    }

    private static boolean matches(CharSequence string, Pattern pattern) {
        return pattern.matcher(string).matches();
    }

    public static String removeVowelsSmart(String str, int maxCountToRemove) {
        int lastIndex;
        StringBuilder result = new StringBuilder(str);
        int firstIndex = 1;
        int removed = 0;
        for (int i = lastIndex = result.length() - 2; i >= firstIndex && removed < maxCountToRemove; --i) {
            if (!NamingStrategyUtils.isVowel(result.charAt(i))) continue;
            result.deleteCharAt(i);
            ++removed;
        }
        return result.toString();
    }

    public static boolean isVowel(char value) {
        switch (value) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }
}

