/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy;

import com.github.fluent.hibernate.cfg.strategy.NamingStrategyUtils;

class NameShorter {
    private int maxLength;
    private final boolean dontTouchFirst;
    private int currentToRemove;

    public NameShorter(int maxLength, boolean dontTouchFirst) {
        this.maxLength = maxLength;
        this.dontTouchFirst = dontTouchFirst;
    }

    public String tableName(String name) {
        return this.makeShorter(name);
    }

    public String columnName(String name) {
        return this.makeShorter(name);
    }

    public String embeddedColumnName(String columnPostfix) {
        return this.makeShorter(columnPostfix);
    }

    public String joinTableName(String name) {
        return this.makeShorter(name);
    }

    public String constraintName(String name) {
        return this.makeShorter(name);
    }

    private String makeShorter(String name) {
        this.currentToRemove = name.length() - this.maxLength;
        if (this.currentToRemove <= 0) {
            return name;
        }
        String[] parts = name.split("_");
        this.makeShorter(parts, name.length());
        return NamingStrategyUtils.concat(parts);
    }

    private void makeShorter(String[] parts, int initialLength) {
        int firstIndex = this.dontTouchFirst ? 1 : 0;
        for (int i = parts.length - 1; i >= firstIndex && this.currentToRemove > 0; --i) {
            parts[i] = this.removeVowels(parts[i]);
        }
    }

    private String removeVowels(String part) {
        String result = NamingStrategyUtils.removeVowelsSmart(part, this.currentToRemove);
        this.currentToRemove -= part.length() - result.length();
        return result;
    }
}

