/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.util.Map;

public final class JoinTableNames {
    private final Map<String, TableDescription> names = InternalUtils.CollectionUtils.newHashMap();

    public boolean hasSameNameForOtherProperty(String tableName, TableDescription descriptionToCheck) {
        TableDescription description = this.names.get(tableName);
        return description != null && !description.isSame(descriptionToCheck);
    }

    public void put(String tableName, TableDescription description) {
        this.names.put(tableName, description);
    }

    public static final class TableDescription {
        private final String owningTable;
        private final String otherTable;
        private final String owningTableProperty;

        public TableDescription(String owningTable, String otherTable, String owningTableProperty) {
            this.owningTable = owningTable;
            this.otherTable = otherTable;
            this.owningTableProperty = owningTableProperty;
        }

        public boolean isSame(TableDescription description) {
            return InternalUtils.equal(this.owningTable, description.owningTable) && InternalUtils.equal(this.otherTable, description.otherTable) && InternalUtils.equal(this.owningTableProperty, description.owningTableProperty);
        }
    }
}

