/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.cfg.scanner.AnnotationChecker;
import com.github.fluent.hibernate.cfg.scanner.ClasspathScanner;
import com.github.fluent.hibernate.cfg.scanner.ResourceUtils;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Entity;
import org.hibernate.cfg.Configuration;

public final class EntityScanner {
    private AnnotationChecker checker;
    private List<ClassLoader> loaders;
    private final String[] packagesToScan;
    private List<Class<?>> result = InternalUtils.CollectionUtils.newArrayList();

    private EntityScanner(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public static EntityScanner scanAllPackages() {
        return EntityScanner.scanPackages(null, null, Entity.class);
    }

    public static EntityScanner scanPackages(String ... packages) {
        InternalUtils.Asserts.isTrue(!InternalUtils.CollectionUtils.isEmptyEllipsis(packages), "You should to specify at least one package to scan.");
        return EntityScanner.scanPackages(packages, null, Entity.class);
    }

    public static EntityScanner scanPackages(List<ClassLoader> loaders, String ... packages) {
        InternalUtils.Asserts.isTrue(!InternalUtils.CollectionUtils.isEmptyEllipsis(packages), "You should to specify at least one package to scan.");
        InternalUtils.Asserts.isTrue(!InternalUtils.CollectionUtils.isEmpty(loaders), "You should to specify at least one class loader.");
        return EntityScanner.scanPackages(packages, loaders, Entity.class);
    }

    static EntityScanner scanPackages(String[] packages, List<ClassLoader> loaders, Class<? extends Annotation> annotation) {
        try {
            return EntityScanner.scanPackagesInternal(packages, loaders, annotation);
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException(ex);
        }
    }

    private static EntityScanner scanPackagesInternal(String[] packages, List<ClassLoader> loaders, Class<? extends Annotation> annotation) throws Exception {
        EntityScanner scanner = new EntityScanner(packages);
        scanner.loaders = loaders;
        scanner.scan(annotation);
        return scanner;
    }

    private void scan(Class<? extends Annotation> annotation) throws Exception {
        this.checker = new AnnotationChecker(annotation);
        ClasspathScanner scanner = new ClasspathScanner(new ClasspathScanner.IResourceAcceptor(){

            @Override
            public void accept(String resource, ClassLoader loader) throws Exception {
                EntityScanner.this.addClassToResult(resource, loader);
            }
        });
        if (this.packagesToScan == null) {
            scanner.allPackagesToScan();
        } else {
            scanner.setPackagesToScan(Arrays.asList(this.packagesToScan));
        }
        scanner.setLoaders(this.loaders);
        scanner.scan();
    }

    private void addClassToResult(String resource, ClassLoader loader) throws IOException {
        if (!ResourceUtils.hasClassExtension(resource)) {
            return;
        }
        if (!this.checker.hasAnnotation(loader.getResourceAsStream(resource))) {
            return;
        }
        Class<?> clazz = InternalUtils.ClassUtils.classForName(ResourceUtils.getClassNameFromPath(resource), loader);
        this.result.add(clazz);
    }

    public EntityScanner addTo(Configuration configuration) {
        for (Class<?> annotatedClass : this.result) {
            configuration.addAnnotatedClass(annotatedClass);
        }
        return this;
    }

    public List<Class<?>> result() {
        return this.result;
    }
}

