/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class ClassFileBuffer
implements DataInput {
    private static final int BUFFER_SIZE_BYTES = 8192;
    private byte[] buffer = new byte[8192];
    private int size;
    private int pointer;

    ClassFileBuffer() {
    }

    public void readFrom(InputStream in) throws IOException {
        int n;
        this.pointer = 0;
        this.size = 0;
        do {
            if ((n = in.read(this.buffer, this.size, this.buffer.length - this.size)) > 0) {
                this.size += n;
            }
            this.resizeIfNeeded();
        } while (n >= 0);
    }

    public void seek(int position) throws IOException {
        if (position < 0) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        if (position > this.size) {
            throw new EOFException();
        }
        this.pointer = position;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int offset, int length) throws IOException {
        if (length < 0 || offset < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pointer + length > this.size) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.pointer, bytes, offset, length);
        this.pointer += length;
    }

    public void skipUnsignedShort() throws IOException {
        this.skipBytes(2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.pointer + n);
        return n;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pointer >= this.size) {
            throw new EOFException();
        }
        return this.buffer[this.pointer++];
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pointer >= this.size) {
            throw new EOFException();
        }
        return this.read();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.pointer + 2 > this.size) {
            throw new EOFException();
        }
        return (this.read() << 8) + this.read();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.pointer + 4 > this.size) {
            throw new EOFException();
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    @Override
    public long readLong() throws IOException {
        if (this.pointer + 8 > this.size) {
            throw new EOFException();
        }
        return ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + (long)(this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() is deprecated and not supported");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    private int read() {
        return this.buffer[this.pointer++] & 0xFF;
    }

    private void resizeIfNeeded() {
        if (this.size >= this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }
}

