/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg;

import com.github.fluent.hibernate.IRequest;
import com.github.fluent.hibernate.IStatelessRequest;
import com.github.fluent.hibernate.cfg.ISessionControl;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;

public final class HibernateSessionFactory {
    private static volatile SessionFactory sessionFactory;
    private static ISessionControl sessionControl;

    private HibernateSessionFactory() {
    }

    static synchronized void closeSessionFactory() {
        if (sessionFactory != null) {
            sessionFactory.close();
            sessionFactory = null;
        }
    }

    public static <T> T doInTransaction(IRequest<T> request) {
        Transaction txn = null;
        Session session = HibernateSessionFactory.openSession();
        T result = null;
        try {
            txn = session.beginTransaction();
            result = request.doInTransaction(session);
            txn.commit();
        }
        catch (Throwable th) {
            HibernateSessionFactory.rollback(txn);
            throw InternalUtils.toRuntimeException(th);
        }
        finally {
            sessionControl.close(session);
        }
        return result;
    }

    public static <T> T doInStatlessTransaction(IStatelessRequest<T> request) {
        Transaction txn = null;
        StatelessSession session = HibernateSessionFactory.openStatelessSession();
        T result = null;
        try {
            txn = session.beginTransaction();
            result = request.doInTransaction(session);
            txn.commit();
        }
        catch (Throwable th) {
            HibernateSessionFactory.rollback(txn);
            throw new RuntimeException(th);
        }
        finally {
            sessionControl.close(session);
        }
        return result;
    }

    private static Session openSession() {
        HibernateSessionFactory.assertSessionFactory();
        return sessionFactory.openSession();
    }

    private static StatelessSession openStatelessSession() {
        HibernateSessionFactory.assertSessionFactory();
        return sessionFactory.openStatelessSession();
    }

    private static void assertSessionFactory() {
        if (sessionFactory == null) {
            throw new IllegalStateException("Firstly create a session factory with Fluent.factory().build()");
        }
    }

    static synchronized void setExistingSessionFactory(SessionFactory sessionFactory, ISessionControl sessionControl) {
        HibernateSessionFactory.sessionControl = sessionControl;
        HibernateSessionFactory.closeSessionFactory();
        HibernateSessionFactory.sessionFactory = sessionFactory;
    }

    private static void rollback(Transaction txn) {
        if (txn != null) {
            txn.rollback();
        }
    }
}

