/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.builder;

import com.github.fluent.hibernate.builder.IBuilder;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.request.HibernateRequest;
import java.util.Collection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InBuilder
implements IBuilder {
    private final String propertyName;
    private final Collection<?> values;
    private boolean nothingForEmptyCollection;

    InBuilder(String propertyName, Collection<?> values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public IBuilder nothingForEmptyCollection() {
        this.nothingForEmptyCollection = true;
        return this;
    }

    @Override
    public <T> void build(HibernateRequest<T> hibernateRequest) {
        if (this.nothingForEmptyCollection && InternalUtils.CollectionUtils.isEmpty(this.values)) {
            hibernateRequest.add(this.getFalseRestriction());
        } else {
            hibernateRequest.in(this.propertyName, this.values);
        }
    }

    private Criterion getFalseRestriction() {
        return Restrictions.sqlRestriction((String)"1<>1");
    }
}

