/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.builder;

import com.github.fluent.hibernate.builder.IBuilder;
import com.github.fluent.hibernate.request.HibernateRequest;

public class EqBuilder
implements IBuilder {
    private final String propertyName;
    private final Object value;
    private boolean ifNotNull;
    private boolean orIsNull;

    EqBuilder(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    public IBuilder ifNotNull() {
        this.ifNotNull = true;
        return this;
    }

    @Override
    public <T> void build(HibernateRequest<T> hibernateRequest) {
        if (this.orIsNull) {
            hibernateRequest.eqOrIsNull(this.propertyName, this.value);
        } else if (!this.ifNotNull || this.value != null) {
            hibernateRequest.eq(this.propertyName, this.value);
        }
    }

    public IBuilder orIsNull() {
        this.orIsNull = true;
        return this;
    }
}

