/*
 * Decompiled with CFR 0.152.
 */
package me.uport.sdk.signer;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.uport.sdk.core.EthNetwork;
import me.uport.sdk.core.Signer;
import me.uport.sdk.signer.TxRelayHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.functions.TransactionRLPEncoderKt;
import org.kethereum.model.Address;
import org.kethereum.model.SignatureData;
import org.kethereum.model.Transaction;
import org.kethereum.model.TransactionKt;
import org.walleth.khex.HexFunKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016JP\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2>\u0010\f\u001a:\u0012\u001b\u0012\u0019\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\t0\rH\u0016JP\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172>\u0010\f\u001a:\u0012\u001b\u0012\u0019\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\t0\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/uport/sdk/signer/TxRelaySigner;", "Lme/uport/sdk/core/Signer;", "wrappedSigner", "network", "Lme/uport/sdk/core/EthNetwork;", "(Lme/uport/sdk/core/Signer;Lme/uport/sdk/core/EthNetwork;)V", "getAddress", "", "signMessage", "", "rawMessage", "", "callback", "Lkotlin/Function2;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lkotlin/ParameterName;", "name", "err", "Lorg/kethereum/model/SignatureData;", "sigData", "signRawTx", "unsignedTx", "Lorg/kethereum/model/Transaction;", "signedEncodedTx", "Companion", "sdk_release"})
public final class TxRelaySigner
implements Signer {
    private final Signer wrappedSigner;
    private final EthNetwork network;
    private static final String whitelistOwner = "0x0000000000000000000000000000000000000000";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getAddress() {
        return this.wrappedSigner.getAddress();
    }

    public void signMessage(@NotNull byte[] rawMessage, @NotNull Function2<? super Exception, ? super SignatureData, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)rawMessage, (String)"rawMessage");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.wrappedSigner.signMessage(rawMessage, callback);
    }

    public void signRawTx(@NotNull Transaction unsignedTx, @NotNull Function2<? super Exception, ? super byte[], Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)unsignedTx, (String)"unsignedTx");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        BigInteger bigInteger = unsignedTx.getNonce();
        if (bigInteger == null) {
            int n = 0;
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            bigInteger = bigInteger2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
        }
        BigInteger nonce = bigInteger;
        Address address = unsignedTx.getTo();
        if (address == null) {
            address = new Address(whitelistOwner);
        }
        Address to = address;
        byte[] data = CollectionsKt.toByteArray((Collection)unsignedTx.getInput());
        String sender = this.wrappedSigner.getAddress();
        String hashInput = "0x1900" + HexFunKt.clean0xPrefix((String)this.network.getTxRelayAddress()) + HexFunKt.clean0xPrefix((String)whitelistOwner) + HexFunKt.toNoPrefixHexString((byte[])BigIntegerKt.toBytesPadded((BigInteger)nonce, (int)32)) + to.getCleanHex() + HexFunKt.toNoPrefixHexString((byte[])data);
        this.signMessage(HexFunKt.hexToByteArray((String)hashInput), (Function2<? super Exception, ? super SignatureData, Unit>)((Function2)new Function2<Exception, SignatureData, Unit>(this, callback, to, data, unsignedTx, nonce, sender){
            final /* synthetic */ TxRelaySigner this$0;
            final /* synthetic */ Function2 $callback;
            final /* synthetic */ Address $to;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ Transaction $unsignedTx;
            final /* synthetic */ BigInteger $nonce;
            final /* synthetic */ String $sender;

            public final void invoke(@Nullable Exception err, @NotNull SignatureData signature) {
                Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
                if (err != null) {
                    this.$callback.invoke((Object)err, (Object)new byte[0]);
                    return;
                }
                byte[] rawMetaTxData = HexFunKt.hexToByteArray((String)new TxRelayHelper(TxRelaySigner.access$getNetwork$p(this.this$0)).abiEncodeRelayMetaTx(signature, this.$to.getHex(), this.$data, "0x0000000000000000000000000000000000000000"));
                BigInteger bigInteger = this.$unsignedTx.getGasPrice();
                BigInteger bigInteger2 = this.$unsignedTx.getGasLimit();
                BigInteger bigInteger3 = BigInteger.ZERO;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger3, (String)"BigInteger.ZERO");
                List list = ArraysKt.toList((byte[])rawMetaTxData);
                String string = null;
                Address address = new Address(this.$sender);
                BigInteger bigInteger4 = this.$nonce;
                Address address2 = new Address(TxRelaySigner.access$getNetwork$p(this.this$0).getTxRelayAddress());
                BigInteger bigInteger5 = bigInteger3;
                BigInteger bigInteger6 = bigInteger2;
                BigInteger bigInteger7 = bigInteger;
                Transaction wrapperTx = TransactionKt.createTransactionWithDefaults$default(null, null, (Address)address, (BigInteger)bigInteger6, (BigInteger)bigInteger7, (List)list, (BigInteger)bigInteger4, (Address)address2, string, (BigInteger)bigInteger5, (int)259, null);
                this.$callback.invoke(null, (Object)TransactionRLPEncoderKt.encodeRLP$default((Transaction)wrapperTx, null, (int)1, null));
            }
            {
                this.this$0 = txRelaySigner;
                this.$callback = function2;
                this.$to = address;
                this.$data = byArray;
                this.$unsignedTx = transaction;
                this.$nonce = bigInteger;
                this.$sender = string;
                super(2);
            }
        }));
    }

    public TxRelaySigner(@NotNull Signer wrappedSigner, @NotNull EthNetwork network) {
        Intrinsics.checkParameterIsNotNull((Object)wrappedSigner, (String)"wrappedSigner");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this.wrappedSigner = wrappedSigner;
        this.network = network;
    }

    @NotNull
    public static final /* synthetic */ EthNetwork access$getNetwork$p(TxRelaySigner $this) {
        return $this.network;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/uport/sdk/signer/TxRelaySigner$Companion;", "", "()V", "whitelistOwner", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

