/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.ico;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.imageio.ico.WindowsIconImageReader;
import vavi.util.Debug;

public class WindowsIconImageReaderSpi
extends ImageReaderSpi {
    private static final String VendorName = "http://www.vavisoft.com";
    private static final String Version = "0.00";
    private static final String ReaderClassName = "vavi.imageio.ico.WindowsIconImageReader";
    private static final String[] Names = new String[]{"ICO"};
    private static final String[] Suffixes = new String[]{"ico", "ICO"};
    private static final String[] mimeTypes = new String[]{"image/x-icon"};
    static final String[] WriterSpiNames = new String[0];
    private static final boolean SupportsStandardStreamMetadataFormat = false;
    private static final String NativeStreamMetadataFormatName = null;
    private static final String NativeStreamMetadataFormatClassName = null;
    private static final String[] ExtraStreamMetadataFormatNames = null;
    private static final String[] ExtraStreamMetadataFormatClassNames = null;
    private static final boolean SupportsStandardImageMetadataFormat = false;
    private static final String NativeImageMetadataFormatName = "ico";
    private static final String NativeImageMetadataFormatClassName = null;
    private static final String[] ExtraImageMetadataFormatNames = null;
    private static final String[] ExtraImageMetadataFormatClassNames = null;

    public WindowsIconImageReaderSpi() {
        super(VendorName, Version, Names, Suffixes, mimeTypes, ReaderClassName, new Class[]{ImageInputStream.class, InputStream.class}, WriterSpiNames, false, NativeStreamMetadataFormatName, NativeStreamMetadataFormatClassName, ExtraStreamMetadataFormatNames, ExtraStreamMetadataFormatClassNames, false, NativeImageMetadataFormatName, NativeImageMetadataFormatClassName, ExtraImageMetadataFormatNames, ExtraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Windows Icon Image";
    }

    @Override
    public boolean canDecodeInput(Object obj) throws IOException {
        if (obj instanceof ImageInputStream) {
            short count;
            short type;
            ImageInputStream is = (ImageInputStream)obj;
            byte[] bytes = new byte[2];
            try {
                is.mark();
                ByteOrder byteOrder = is.getByteOrder();
                is.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                is.readFully(bytes);
                type = is.readShort();
                count = is.readShort();
                is.setByteOrder(byteOrder);
                is.reset();
            }
            catch (IOException e) {
                Debug.println((Object)e);
                return false;
            }
            return bytes[0] == 0 && bytes[1] == 0 && type == 1 && count > 0;
        }
        Debug.println((Object)obj);
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object obj) {
        return new WindowsIconImageReader(this);
    }
}

