/*
 * Decompiled with CFR 0.152.
 */
package vavi.imageio.am88;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import vavi.awt.image.am88.ArtMasterImage;
import vavi.imageio.WrappedImageInputStream;
import vavi.util.Debug;

public class ArtMasterImageReader
extends ImageReader {
    private IIOMetadata metadata;
    private BufferedImage image;

    public ArtMasterImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(imageIndex + "/1");
        }
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(imageIndex + "/1");
        }
        return this.image.getHeight();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        InputStream is = null;
        if (this.input instanceof ImageInputStream) {
            is = new WrappedImageInputStream((ImageInputStream)this.input);
        } else if (this.input instanceof InputStream) {
            is = (InputStream)this.input;
        } else {
            Debug.println((Object)this.input);
        }
        try {
            ArtMasterImage ami = new ArtMasterImage(is);
            this.image = new BufferedImage(ami.getWidth(), ami.getHeight(), 13, (IndexColorModel)ami.getColorModel());
            this.image.getRaster().setDataElements(0, 0, ami.getWidth(), ami.getHeight(), ami.getPixels());
            return this.image;
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return this.metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(imageIndex + "/1");
        }
        return this.metadata;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(imageIndex + "/1");
        }
        Object specifier = null;
        ArrayList l = new ArrayList();
        l.add(specifier);
        return l.iterator();
    }
}

